DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_providernqfdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_providernqfdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
begin

select distinct case when aaw.itemCode='3' then prog.programRegistrationId else '' end Learnership_Id,
case when aaw.itemCode <> '3' then prog.programRegistrationId else '' end Qualification_Id,
'' as Filler01,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id, '' as Filler02, '' as Filler03,
case when prog.educationDepartmentRegistrationDate is not null then 
DATE_FORMAT(prog.educationDepartmentRegistrationDate, '%Y%m%d') else 20160101 end as Provider_Accred_Start_Date,
'' as Provider_Accred_End_Date,
'' as Filler04,
case when alpur.tilldate>=date(now()) then '1' else '575' end as Provider_Status_Id,
max(case when mda.itemCode='3' then '3' when mda.itemCode='4' then '4' else '7' end) as Offering_Type_Id,
date_format(now(), '%Y%m%d') as Date_Stamp
from programs prog
left join academic_award aaw on(aaw.id=prog.academicAwardId)
join academy_location al on(al.id=prog.academyLocationId)
join locations loc on(loc.id=al.locationId)
left join academy_location_purpose alpur on(alpur.academyLocationId=al.id and purposeCode='COURSE_EXECUTION')
join batches batcha on (prog.id=batcha.programId and batcha.intakeYearId=intakeYearId and batcha.startDate < NOW())
join mode_of_delivery mda on(batcha.modeOfDeliveryId=mda.id) 
where loc.shortCode <> 'FBC' and prog.programRegistrationId is not null and prog.status='O' and   FIND_IN_SET( al.id,p_alid)
group by loc.id, prog.programRegistrationId;

END//
DELIMITER ;