DELIMITER $$
DROP PROCEDURE IF EXISTS V20220622171955__Create_Enrollment_Main $$
CREATE PROCEDURE V20220622171955__Create_Enrollment_Main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='online_enrollment')) THEN 
CREATE TABLE `online_enrollment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `onlineEnrollmentMasterId` bigint(20) NOT NULL,
  `courseId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `batchId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `courseStatus` varchar(255) DEFAULT NULL,
  `whetherOptional` bit(1) DEFAULT b'0',
  `whetherCourseExempted` bit(1) DEFAULT b'0',
  `sectionType` varchar(255) DEFAULT NULL,
  `studentCourseEnrollmentCriteria` varchar(255) DEFAULT NULL,
  `midtermGrade` varchar(255) DEFAULT NULL,
  `feePlanRuleId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `courseGroupId` bigint(20) DEFAULT NULL,
  `billId` bigint(20) DEFAULT NULL,
  `isActive` BIT(1) DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_online_enrollment_master1_idx` (`onlineEnrollmentMasterId`),
  CONSTRAINT `fk_online_enrollment_master1` FOREIGN KEY (`onlineEnrollmentMasterId`) REFERENCES `online_enrollment_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;  

END $$
CALL V20220622171955__Create_Enrollment_Main () $$ 
DROP PROCEDURE IF EXISTS V20220622171955__Create_Enrollment_Main $$ 
DELIMITER ;