DROP procedure IF EXISTS `student_attendance_day_wise_weekly_summary`;
DELIMITER $$
CREATE  PROCEDURE `student_attendance_day_wise_weekly_summary`(IN studentIds VARCHAR(15000))
BEGIN
  
select
-- tmp1.ID as ID,
CONCAT(tmp1.MOBILE_CODE,tmp1.MOBILE_NO) as `MOBILE_NO`,
tmp1.STUDENT_NAME as `STUDENT_NAME`,
tmp1.USER_CODE as `USER_CODE`,
-- tmp1.LAST_NAME as `LAST_NAME`,
DATE_FORMAT(now(), '%d-%m-%Y'),
SUM(tmp1.TOTAL_PRESENT + tmp1.TOTAL_ABSENT) as totalDay,
CONCAT(tmp1.PRESENT_PERCENTAGE,'%') as `PRESENT_PERCENTAGE`
from
(
select T3.studentId as `ID`,
count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_PRESENT`,
count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_ABSENT`,
ROUND((count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))/
(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `PRESENT_PERCENTAGE`,
ROUND((count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))/
(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `ABSENT_PERCENTAGE`,
T5.printName as `STUDENT_NAME`,
T6.code as USER_CODE,
T5.mobileNumber as `MOBILE_NO`,
T5.mobileCountryCode as `MOBILE_CODE`,
T5.emailId as `EMAIL_ID`,
ml.`code` as LANGUAGE_KEY
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
inner join users T6 on T6.id = T4.userId
left join  multi_language ml ON ml.id = T5.correspondence_language
-- where T3.studentId in (', studentIds, ')
where FIND_IN_SET(T3.studentId, studentIds)
and (T1.dateOfAttendance BETWEEN DATE_FORMAT(SUBDATE(NOW(),7),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d'))
group by T3.studentId
order by T3.studentId
) tmp1
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
-- where T3.studentId in (', studentIds, ')
where FIND_IN_SET(T3.studentId, studentIds)
and dateOfAttendance = DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp2 on tmp2.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
-- where T3.studentId in (', studentIds, ')
where FIND_IN_SET(T3.studentId, studentIds)
and dateOfAttendance = DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp3 on tmp3.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
-- where T3.studentId in (studentIds)
where FIND_IN_SET(T3.studentId, studentIds)
and dateOfAttendance = DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp4 on tmp4.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
-- where T3.studentId in (', studentIds, ')
where FIND_IN_SET(T3.studentId, studentIds)
and dateOfAttendance = DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp5 on tmp5.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (4)
and dateOfAttendance = DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp6 on tmp6.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
-- where T3.studentId in (', studentIds, ')
where FIND_IN_SET(T3.studentId, studentIds)
and dateOfAttendance = DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp7 on tmp7.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
-- where T3.studentId in (', studentIds, ')
where FIND_IN_SET(T3.studentId, studentIds)
and dateOfAttendance = DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')
group by T3.studentId
order by T3.studentId
) tmp8 on tmp8.studentId = tmp1.`ID`;

END$$
DELIMITER ;