DELIMITER $$
DROP PROCEDURE IF EXISTS V20220721183216__Update_DataProviderforAdmissionInfo $$
CREATE PROCEDURE V20220721183216__Update_DataProviderforAdmissionInfo()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT id FROM dydt_data_provider WHERE `providerName`='ADMISSION_DATA_PROVIDER')) THEN 
SET SQL_SAFE_UPDATES=0;

SET @dydtdataproviderId=(SELECT id FROM dydt_data_provider WHERE `providerName`='ADMISSION_DATA_PROVIDER');

UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT p.programCode AS program_code, p.programName AS program_name, p.programNameToBePrint AS program_print_name, pd.shortCode AS primary_dept_code, pd.deptName AS primary_dept_name, psd.shortCode AS secondary_dept_code, psd.deptName AS secondary_dept_name, b.batchName AS batch_name, b.startDate AS batch_start_date, b.tillDate AS batch_tilldate, ay.itemValue AS academic_year, a.code AS admission_code, a.studentId AS student_id, pbpc.printName AS last_period_name,DATE_FORMAT(pbpc.programPeriodStart ,"%d-%m-%Y") as period_start_date,DATE_FORMAT(pbpc.programPeriodEnd ,"%d-%m-%Y") as period_end_date, epr.sgpa AS SGPA_of_last_period, ad.pincode AS post_number , u.printName as program_advisor, des.itemValue as program_advisor_designation, (SELECT prog_batch_period_config.printName FROM evaluation_period_rank LEFT JOIN prog_batch_period_config ON prog_batch_period_config.id = evaluation_period_rank.periodId WHERE evaluation_period_rank.admissionId = a.id ORDER BY evaluation_period_rank.id DESC LIMIT 1 OFFSET 1) as second_last_period FROM admission a LEFT JOIN programs p ON a.programId = p.id LEFT JOIN prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id LEFT JOIN batches b ON b.id = pbsc.programBatchId LEFT JOIN intake_year ay ON ay.id = b.intakeYearId LEFT JOIN department pd ON pd.id = p.programDepartmentId LEFT JOIN department psd ON psd.id = p.subDepartmentId LEFT JOIN prog_batch_period_config pbpc ON pbpc.programBatchId = pbsc.programBatchId LEFT JOIN evaluation_period_rank epr ON epr.periodId = pbpc.id AND epr.admissionId = a.id LEFT JOIN students s ON a.studentId = s.userId LEFT JOIN persons per ON s.personId = per.id LEFT JOIN person_addresses pad ON pad.personId = per.id AND pad.addresstypeId = 7 LEFT JOIN address ad ON ad.id = pad.addressId Left join users u on p.approver=u.id left join staffs staffs on u.id=staffs.userId left join designations des on staffs.designationId=des.id',
    `resultColumnsDef` = 'program_code,program_name,program_print_name, primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate,academic_year,admission_code,student_id,last_period_name,period_start_date,period_end_date,SGPA_of_last_period,post_number,program_advisor,program_advisor_designation,second_last_period',
    `sqlWhereQueryDef` = 'WHERE a.id = PRM_ADMISSION_ID ORDER BY epr.periodId DESC LIMIT 1'
WHERE
    `dataSourceCode` = 'ADMISSION_INFO'
        AND dataProviderId = @dydtdataproviderId
        AND whereClauseBindingDef = 'PRM_ADMISSION_ID';
 
SET SQL_SAFE_UPDATES=1;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20220721183216__Update_DataProviderforAdmissionInfo () $$
DROP PROCEDURE IF EXISTS V20220721183216__Update_DataProviderforAdmissionInfo $$
DELIMITER ;