DELIMITER $$
DROP PROCEDURE IF EXISTS V20220805132223__Insert_reportTemplate $$
CREATE PROCEDURE V20220805132223__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GRADE_AVERAGE_REPORT_BY_SURNAME')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'GRADE_AVERAGE_REPORT_BY_SURNAME', 'Grade average report sort by surname', 'GRADE_AVERAGE_REPORT_BY_SURNAME.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'ExportGradeAverageReportBySurname.jasper', 'AcademiaLogo.png');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GRADE_AVERAGE_REPORT_BY_RANK')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'GRADE_AVERAGE_REPORT_BY_RANK', 'Grade average report sort by rank', 'GRADE_AVERAGE_REPORT_BY_RANK.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'ExportGradeAverageReportByRank.jasper', 'AcademiaLogo.png');
END IF;

set @tempKeySurname = (select id from report_template where templateCode ='GRADE_AVERAGE_REPORT_BY_SURNAME');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_STUDENT_FIRSTNAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_STUDENT_FIRSTNAME', 'First Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_STUDENT_LASTNAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_STUDENT_LASTNAME', 'Surname', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_ASSESSMENT_LEVEL_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_ASSESSMENT_LEVEL_NAME', 'Assessment Level Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_STUDENT_AVERAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_STUDENT_AVERAGE', 'Student Average', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_STUDENT_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_STUDENT_MARKS', 'Student Marks', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_GRADE_AVERAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_GRADE_AVERAGE', 'Grade Average', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_PROMOTION_RESULT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_PROMOTION_RESULT', 'Promotion Result', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeySurname and keyValue='TRANS_OVERALL_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeySurname, 'TRANS_OVERALL_MARKS', 'Overall Mark', '1', now());
END IF;

set @tempKeyRank = (select id from report_template where templateCode ='GRADE_AVERAGE_REPORT_BY_RANK');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_STUDENT_FIRSTNAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_STUDENT_FIRSTNAME', 'First Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_STUDENT_LASTNAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_STUDENT_LASTNAME', 'Surname', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_STUDENT_RANK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_STUDENT_RANK', 'Program Rank', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_ASSESSMENT_LEVEL_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_ASSESSMENT_LEVEL_NAME', 'Assessment Level Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_STUDENT_AVERAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_STUDENT_AVERAGE', 'Student Average', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_STUDENT_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_STUDENT_MARKS', 'Student Marks', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_GRADE_AVERAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_GRADE_AVERAGE', 'Grade Average', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_PROMOTION_RESULT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_PROMOTION_RESULT', 'Promotion Result', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKeyRank and keyValue='TRANS_OVERALL_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKeyRank, 'TRANS_OVERALL_MARKS', 'Overall Mark', '1', now());
END IF;

END $$
CALL V20220805132223__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20220805132223__Insert_reportTemplate $$
DELIMITER ;