DELIMITER $$
DROP PROCEDURE IF EXISTS V20221004182942__Update_UpdateCourseWise $$
CREATE PROCEDURE V20221004182942__Update_UpdateCourseWise()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_PARENT_RCPNT')) THEN 

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_PARENT_RCPNT');
update sql_dtprovider set sqlQuery = "select ID,
    FIRST_NAME,
    LAST_NAME,
    STUDENT_CODE,
    PARENT_FIRST_NAME,
    PARENT_LAST_NAME,
    EMAIL_ID,
    MOBILE_NO,
    MOBILE_CODE,
    COURSE_NAME,
    COURSE_CODE,
    FACULTY_FIRSTNAME,
    FACULTY_LASTNAME,
    SALUTATION,
    PARENT_SALUTATION,
    BATCH_NAME,
    PROGRAM_NAME,
    PERIOD_NAME,
    ACADEMY_NAME,
    LANGUAGE_KEY,
   COUNT(IF(a.attendanceStatus = 'PRESENT',
        a.attendanceStatus,
        NULL)) + COUNT(IF(a.attendanceStatus <> 'PRESENT',
        a.attendanceStatus,
        NULL)) AS TOTAL_SESSIONS,
    COUNT(IF(a.attendanceStatus = 'PRESENT',
        a.attendanceStatus,
        NULL)) AS TOTAL_PRESENT,
    COUNT(IF(a.attendanceStatus = 'ABSENT',
        a.attendanceStatus,
        NULL)) AS TOTAL_ABSENT,
    COUNT(IF(a.attendanceStatus = 'LEAVE',
        a.attendanceStatus,
        NULL)) AS TOTAL_LEAVE,
    ROUND((COUNT(IF(a.attendanceStatus = 'PRESENT',
                a.attendanceStatus,
                NULL)) / (COUNT(IF(a.attendanceStatus = 'PRESENT',
                a.attendanceStatus,
                NULL)) + COUNT(IF(a.attendanceStatus <> 'PRESENT',
                a.attendanceStatus,
                NULL)))) * 100) AS PRESENT_PERCENTAGE
  from (
 SELECT
    T13.id AS ID,cv.courseId , sce.sectionId , sce.courseVarientId , adm.studentId ,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T16.code AS STUDENT_CODE,
    T13.firstName AS PARENT_FIRST_NAME,
    T13.lastName AS PARENT_LAST_NAME,
    T13.emailId AS EMAIL_ID,
    T13.mobileNumber AS MOBILE_NO,
    T13.mobilecountrycode AS MOBILE_CODE,
    cou.nameToBePrinted AS COURSE_NAME,
    cou.courseCode AS COURSE_CODE,
    T9.firstName AS FACULTY_FIRSTNAME,
    T9.lastName AS FACULTY_LASTNAME,
    T10.salutationName AS SALUTATION,
    T15.salutationName AS PARENT_SALUTATION,
    bch.batchName AS BATCH_NAME,
    prg.programNameToBePrint AS PROGRAM_NAME,
    per.programPeriodName AS PERIOD_NAME,
    T18.displayName AS ACADEMY_NAME,
    ml.code AS LANGUAGE_KEY,scad.attendanceStatus
  /*  COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS TOTAL_SESSIONS,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS TOTAL_PRESENT,
    COUNT(IF(scad.attendanceStatus = 'ABSENT',
        scad.attendanceStatus,
        NULL)) AS TOTAL_ABSENT,
    COUNT(IF(scad.attendanceStatus = 'LEAVE',
        scad.attendanceStatus,
        NULL)) AS TOTAL_LEAVE,
    ROUND((COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) / (COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
                scad.attendanceStatus,
                NULL)))) * 100) AS PRESENT_PERCENTAGE */
FROM
    student_course_enrollment sce
        JOIN
    prog_batch_period_config per ON per.id = sce.programBatchPeriodConfigId
        JOIN
    admission adm ON adm.id = sce.admissionId
        JOIN
    batches bch ON bch.id = per.programBatchId
        JOIN
    programs prg ON prg.id = bch.programId
        JOIN
    course_variants cv ON cv.id = sce.courseVarientId
        JOIN
    courses cou ON cou.id = cv.courseId
        OR cou.parentCourseId = cv.courseId
        JOIN
    program_batch_course_param param ON param.courseVarientId = cv.id
    and param.progBatchPeriodConfigId=sce.programBatchPeriodConfigId
        JOIN
    prog_batch_course_faculty fac ON fac.progBatchCourseParamId = param.id
        LEFT JOIN
    student_course_attendance sca ON sca.variantId = sce.courseVarientId
        LEFT JOIN
    student_course_attendance_details scad ON scad.attendanceId = sca.id
        AND adm.id = scad.admissionId
        LEFT JOIN
    users T16 ON T16.id = adm.studentId
        LEFT JOIN
    students T6 ON T6.userId = T16.id
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    staffs T8 ON T8.userId = fac.facultyId
        LEFT JOIN
    persons T9 ON T9.id = T8.personId
        LEFT JOIN
    salutations T10 ON T10.id = T9.salutationId
        LEFT JOIN
    person_relationships T12 ON T12.personId = T7.id
        LEFT JOIN
    persons T13 ON T13.id = T12.relatedPersonId
        LEFT JOIN
    salutations T15 ON T15.id = T13.salutationId
        LEFT JOIN
    academy_location T18 ON T18.id = prg.academyLocationId
        LEFT JOIN
    multi_language ml ON ml.id = T7.correspondence_language
WHERE
    per.isCurrentPeriodOfProgram = 1
        AND T13.id IN (namedParams)
        AND sce.exitDate IS NULL
        AND per.programPeriodEnd >= NOW()
 GROUP BY cv.courseId , sce.sectionId , sce.courseVarientId , adm.studentId , T13.id,param.id,sca.id
) as a
GROUP BY a.courseId , a.sectionId , a.courseVarientId , a.studentId , a.id" where dataProviderId=@dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20221004182942__Update_UpdateCourseWise () $$
DROP PROCEDURE IF EXISTS V20221004182942__Update_UpdateCourseWise $$
DELIMITER ;