DELIMITER $$
DROP PROCEDURE IF EXISTS V20221109193418__Update_ApplicationRecipentsQuerys $$
CREATE PROCEDURE V20221109193418__Update_ApplicationRecipentsQuerys()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_RECIPIENT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_RECIPIENT');
update sql_dtprovider set sqlQuery = "SELECT 
    sg.id AS ID,
    T1.code AS APPLICANT_CODE,
    T2.firstName AS FIRST_NAME,
    T2.lastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    ml.code as LANGUAGE_KEY,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl)
    else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
    LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT  JOIN
    address T6 ON T6.id = T5.addressId 
        LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id
WHERE
    sg.id IN (namedParams) and sg.isAppointeeAppointment = TRUE and T6.addressTypeId = 10" where dataProviderId=@dtproviderId;
END IF; 


IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT');
update sql_dtprovider set sqlQuery = "SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
     ml.`code` as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T8.id
        LEFT OUTER JOIN
    address T6 ON T6.id = T5.addressId 
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T4.correspondence_language
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams) AND T6.addressTypeId = 10" where dataProviderId=@dtproviderId;
END IF; 


IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_APPOINTMENT_RECIPIENT')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_APPOINTMENT_RECIPIENT');
update sql_dtprovider set sqlQuery = "SELECT 
     sg.id AS ID,
     T1.code AS APPLICANT_CODE,
     sg.appointeeName AS APPOINTEE_PRINT_NAME,
     sg.appointeeEmailId AS APPOINTEE_EMAIL_ID,
     DATE_FORMAT(sg.visitTime, '%h:%i %p') AS VISIT_TIME,
     DATE_FORMAT(sg.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
     TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
     T4.academyName AS ACADEMY_NAME,
     T4.locationName AS LOCATION_NAME,
     T4.displayName AS ACADEMY_NAME_LOCATION,
     T2.`emailId` AS EMAIL_ID,
     T2.`mobileNumber` AS MOBILE_NO,
     T2.`mobileCountryCode` AS MOBILE_CODE,
     T2.`firstName` AS FIRST_NAME,
     T2.`lastName` AS LAST_NAME,
     T15.`programNameToBePrint` AS PROGRAM_NAME,
     T14.`printName` AS BATCH_PRINT_NAME,
     T16.`seatName` AS SEAT_TYPE,
     CONCAT(T6.addressText,' ',T7.cityName,', ',T8.countryName,', ',T9.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
     CONCAT(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
     T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
     T6.websiteURL AS ACADEMY_LOCATION_URL,
     T10.printName OWNER_NAME,
     (CASE
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'APPLIED'
         THEN
             'Applied'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'NOT_APPLIED'
         THEN
             'Not Applied'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'SOLD'
         THEN
             'Sold'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'SUBMITTED'
         THEN
             'Submitted'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'APPROVED'
         THEN
             'Approved'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'REJECTED'
         THEN
             'Rejected'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'WITHDRAWN'
         THEN
             'Withdrawn'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'CLOSED'
         THEN
             'Closed'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'DIRECT_ADMISSION'
         THEN
             'Direct Admission'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'MID_TERM_ADMISSION'
         THEN
             'Mid term admission'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
         THEN
             'Direct submission token generated'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
         THEN
             'Form sale token generated'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'NOT_SUBMITTED'
         THEN
             'Not Submitted'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'ADMISSION_GRANTED'
         THEN
             'Admission granted'
         ELSE ''
     END) AS APPLICATION_STATUS,
     (CASE
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'OFFER_LETTER_ACCEPTED'
         THEN
             'Offer letter accepted'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'OFFER_LETTER_ISSUED'
         THEN
             'Offer letter issued'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'OFFER_LETTER_REJECTED'
         THEN
             'Offer letter rejected'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'OFFER_LETTER_DUE'
         THEN
             'Offer letter due'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'ACTIVE'
         THEN
             'Active'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'APPROVED'
         THEN
             'Approved'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'ADMITTED'
         THEN
             'Admitted'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'ADMITTED_ON_TRIAL'
         THEN
             'Admitted on trial'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'ADMITTED_ON_PROVISIONAL'
         THEN
             'Admitted on provisional'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'REJECTED'
         THEN
             'Rejected'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'WITHDRAWN'
         THEN
             'Withdrawn'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
         THEN
             'Withdrawn after accepting offer letter'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'CLOSED'
         THEN
             'Closed'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
         THEN
             'Provisional offer issued'
             WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
         THEN
             'Provisional offer rejected'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'PROVISIONAL_OFFER_DUE'
         THEN
             'Provisional offer due'
         WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'OFFER_EXPIRED'
         THEN
             'Offer Expired'
             WHEN
             T11.currentStatus IS NOT NULL
                 AND T11.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
         THEN
             'Provisional Offer Expired'
         ELSE ''
     END) AS OFFER_STATUS,
     DATE_FORMAT(T1.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
     (Case 
     when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
     when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
     else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
     (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
     else NULL end) as HEADER_URL,
     (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
     else NULL end) as FOOTER_URL,
     T12.id as ACADEMY_LOCATION_ID,
     T12.academyId as ACADEMY_ID
 FROM
     sg_appointment sg
         INNER JOIN
     application T1 ON T1.id = sg.applicationId
         LEFT OUTER JOIN
     application_program T11 ON T11.applicationId = T1.id
         LEFT OUTER JOIN
     academy_location T12 ON T12.id = T11.academyLocationId        
         LEFT OUTER JOIN
     prog_batch_seat_config T13 on T13.id = T11.progBatchSeatConfigId
         LEFT OUTER JOIN
     batches T14 on T14.id = T13.programBatchId
         LEFT OUTER JOIN
     programs T15 ON T15.id = T11.programId        
         LEFT JOIN
     seat_types T16 on T16.id = T13.seatTypeId
         LEFT JOIN
     applicant_person T2 ON T2.id = T1.applicantPersonId        
         LEFT JOIN
     academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
         LEFT JOIN
     academy_location_addresses T5 ON T5.academyLocationId = T4.id
         LEFT JOIN
     address T6 ON T6.id = T5.addressId 
         LEFT JOIN
     organizations org on org.id = 1
         LEFT OUTER JOIN
     city T7 ON T7.id = T6.cityId
         LEFT OUTER JOIN
     country T8 ON T8.id = T7.countryId
         LEFT OUTER JOIN
     country_region T9 ON T9.id = T7.countryRegionId
         LEFT OUTER JOIN
     users T10 ON T10.id = T1.applicationOwner
 WHERE
     sg.id IN (namedParams) and AND T6.addressTypeId = 10" where dataProviderId=@dtproviderId;
END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20221109193418__Update_ApplicationRecipentsQuerys () $$
DROP PROCEDURE IF EXISTS V20221109193418__Update_ApplicationRecipentsQuerys $$
DELIMITER ;