DELIMITER $$
DROP PROCEDURE IF EXISTS V20221123161919__Insert_PaymentOptionDynamicDoc $$
CREATE PROCEDURE V20221123161919__Insert_PaymentOptionDynamicDoc()
BEGIN

IF  EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT min(dataProviderId) FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'PAYMENT_OPTION_DETAILS', '6',null, '1', '0', 
'SELECT fd.paymentMode AS PAYMENT_MODE, dod.itemValue AS DEBIT_ORDER_DATE, fd.accountType AS ACCOUNT_TYPE, fd.accountName AS ACCOUNT_NAME, 
    fd.accountNumber AS ACCOUNT_NUMBER, bk.bankName AS BANK_NAME,branch.itemCode AS BRANCH_CODE from 
    fee_payer_detail fd 
    LEFT OUTER JOIN debit_order_date dod ON dod.id = fd.debitOrderDateCSMId
    LEFT OUTER JOIN bank_drawn_on_master bk ON bk.id = fd.bankId
    LEFT OUTER JOIN bank_drawn_child branch ON branch.id = fd.branchCode
    left outer JOIN students st on st.personId = fd.personId
	left outer join admission a on a.studentId = st.userId', 
    'PRM_ADMISSION_ID', 
	'PAYMENT_MODE, DEBIT_ORDER_DATE, ACCOUNT_TYPE, ACCOUNT_NAME, ACCOUNT_NUMBER, BANK_NAME, BRANCH_CODE',
"where a.id=PRM_ADMISSION_ID and fd.paymentMode='DEBIT_ORDER'", '1');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('PAYMENT_MODE', 'Payment Mode',@dydtdatalinitemId+1),
('DEBIT_ORDER_DATE', 'Debit Order Date',@dydtdatalinitemId+1),
('ACCOUNT_TYPE', 'Account Type',@dydtdatalinitemId+1),
('ACCOUNT_NAME', 'Account Name',@dydtdatalinitemId+1),
('ACCOUNT_NUMBER', 'Account Number',@dydtdatalinitemId+1),
('BRANCH_CODE', 'Branch Code',@dydtdatalinitemId+1),
('BANK_NAME', 'Bank Name',@dydtdatalinitemId+1);

END IF; 

END $$
CALL V20221123161919__Insert_PaymentOptionDynamicDoc() $$
DROP PROCEDURE IF EXISTS V20221123161919__Insert_PaymentOptionDynamicDoc $$
DELIMITER ;