DELIMITER $$
DROP PROCEDURE IF EXISTS V20230223162938__Create_membershipdefination $$
CREATE PROCEDURE V20230223162938__Create_membershipdefination()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='membership_defination')) THEN 
CREATE TABLE membership_defination (
  id BIGINT NOT NULL AUTO_INCREMENT,
  committeeId  BIGINT NOT NULL,
  membershiptypeId BIGINT NOT NULL,
  memberShipStartDate Date,
  memberShipEndDate Date,
  applicationStartDate Date,
  applicationEndDate  Date,
  isOnlineApplication BIT(1) NOT NULL,
  isFeeApplicable BIT(1) NOT NULL,
  isAutoApprove BIT(1) NOT NULL,
  feeplanId BIGINT  NULL,
  feeplanruleId BIGINT  NULL,
  userId BIGINT  NULL,
  lastUpdatedBy BIGINT NOT NULL,
  lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  INDEX fk_membership_type_defination_to_membership_type_idx (membershiptypeId ASC),
  INDEX fk_membership_type_defination_to_committee_idx (committeeId ASC),
  INDEX fk_membership_type_defination_to_fee_plan_idx (feeplanId ASC) ,
  INDEX fk_membership_type_defination_to_fee_plan_rule_idx (feeplanruleId ASC) ,
  INDEX fk_membership_type_defination_to_users_idx (userId ASC) ,
  CONSTRAINT fk_membership_type_defination_to_membership_type
    FOREIGN KEY (membershiptypeId)
    REFERENCES membership_type (id)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT fk_membership_type_defination_to_committee
    FOREIGN KEY (committeeId)
    REFERENCES committee (id)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT fk_membership_type_defination_to_fee_plan
    FOREIGN KEY (feeplanId)
    REFERENCES fee_plan (id)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT fk_membership_type_defination_to_fee_plan_rule
    FOREIGN KEY (feeplanruleId)
    REFERENCES fee_plan_rules (id)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT fk_membership_type_defination_to_users
    FOREIGN KEY (userId)
    REFERENCES users (id)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT fk_membership_type_defination_to_lastUpdateBy
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT
    );
END IF;

END $$
CALL V20230223162938__Create_membershipdefination () $$ 
DROP PROCEDURE IF EXISTS V20230223162938__Create_membershipdefination $$ 
DELIMITER ;