DELIMITER $$
DROP PROCEDURE IF EXISTS V20230329002827__Create_business_rule_conditions_attribute $$
CREATE PROCEDURE V20230329002827__Create_business_rule_conditions_attribute()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_conditions_attribute')) THEN 
CREATE TABLE `business_rule_conditions_attribute` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `codeValue` VARCHAR(255) NOT NULL,
  `nameValue` VARCHAR(255) NOT NULL,
  `attributeTypeId` BIGINT NOT NULL,
  `applicableOn` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_business_rule_conditions_attribute_attributeTypeId_idx` (`attributeTypeId` ASC),
  INDEX `fk_business_rule_conditions_attribute_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_business_rule_conditions_attribute_attributeTypeId`
    FOREIGN KEY (`attributeTypeId`)
    REFERENCES `attribute_type` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_business_rule_conditions_attribute_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
INSERT INTO `business_rule_conditions_attribute`(`codeValue`,`nameValue`,`attributeTypeId`,`applicableOn`,`lastUpdate`,`lastUpdatedBy`) VALUES ('course_attendance','Course / Attendance',1,NULL,now(),1);
INSERT INTO `business_rule_conditions_attribute`(`codeValue`,`nameValue`,`attributeTypeId`,`applicableOn`,`lastUpdate`,`lastUpdatedBy`) VALUES ('course_result','Course / Result',2,NULL,now(),1);
INSERT INTO `business_rule_conditions_attribute`(`codeValue`,`nameValue`,`attributeTypeId`,`applicableOn`,`lastUpdate`,`lastUpdatedBy`) VALUES ('period_attendance','Period / Attendance',1,NULL,now(),1);
INSERT INTO `business_rule_conditions_attribute`(`codeValue`,`nameValue`,`attributeTypeId`,`applicableOn`,`lastUpdate`,`lastUpdatedBy`) VALUES ('outstanding_balance_due_fees_percentage','Outstanding Balance / Due Fees Percentage',3,'Due Fees Percentage',now(),1);
INSERT INTO `business_rule_conditions_attribute`(`codeValue`,`nameValue`,`attributeTypeId`,`applicableOn`,`lastUpdate`,`lastUpdatedBy`) VALUES ('outstanding_balance_due_fees_amount','Outstanding Balance / Due Fees Amount',3,'Due Fees Amount',now(),1);
END IF; 

END $$
CALL V20230329002827__Create_business_rule_conditions_attribute () $$ 
DROP PROCEDURE IF EXISTS V20230329002827__Create_business_rule_conditions_attribute $$ 
DELIMITER ;