DELIMITER $$
DROP PROCEDURE IF EXISTS V20230508184955__Update_PostgraduateManaStudDataprovider $$
CREATE PROCEDURE V20230508184955__Update_PostgraduateManaStudDataprovider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'POST_GRADUATE_MANAGEMENT_STUDENTS_INFO')) THEN 
UPDATE dydt_data_line_item
SET  sqlSelectQueryDef= "select 
T4.id AS id,
T4.firstName AS student_first_name,
T4.middleName AS student_middle_name,
T4.lastName AS student_last_name,
T1.code as student_id,
T4.externalSysRefOne AS student_su_number,
T4.mobileNumber AS Student_mobile_no,
T4.emailId AS student_email_id,
T9.itemValue AS Year,
T5.programName AS program_name,
T5.fieldOfStudyLanguageTwo AS filed_of_study,
T6.doctoral_thesis AS dissertation_or_thesis_title,
T7.deptName AS supervisor_department,
T10.salutationName AS student_title,
T11.itemValue AS student_gender,
T12.deptName AS prg_department,
T15.academyName AS faculty,
T16.locationName AS campus,
T13.title AS thesis_title

from admission T3
left join users T1 on T1.id=T3.studentId
left join students T2 on T2.userId=T1.id
left join  persons T4 on T4.id=T2.personId
left join programs T5 on T5.id=T3.programId
left join batches T8 on T8.id =T3.batchId
left join intake_year T9 on T9.id= T8.intakeYearId
left join post_school_studies_section T6 on T6.persons_id=T2.personId
left join department T7 on T7.id=T5.programDepartmentId
left join salutations T10 on T10.id=T4.salutationId
left join gender T11 on T11.id=T4.genderId
left join department T12 on T12.id=T5.programDepartmentId
left join student_thesis_title T13 on T13.personId=T4.id
left join academy_location T14 on T14.id=T3.academyLocationId
left join academies T15 on T15.id=T14.academyId
left join locations T16 on T16.id=T14.locationId"
,resultColumnsDef="student_first_name,student_middle_name,student_last_name,student_id,student_su_number,Student_mobile_no,student_email_id,Year,program_name,filed_of_study,dissertation_or_thesis_title,supervisor_department,student_title,student_gender,prg_department,thesis_title,faculty,campus"

WHERE dataSourceCode = 'POST_GRADUATE_MANAGEMENT_STUDENTS_INFO';

#------------------TRANSLATIONS---------------------
  
	SET @dydtdatalinitemId = (SELECT id FROM `dydt_data_line_item` where dataSourceCode='POST_GRADUATE_MANAGEMENT_STUDENTS_INFO');
  
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('student_title', 'Student Title',@dydtdatalinitemId),
    ('student_gender', 'Student Gender',@dydtdatalinitemId),
    ('prg_department', 'Program Department ',@dydtdatalinitemId),
    ('thesis_title', 'Thesis Title',@dydtdatalinitemId),
    ('faculty', 'Faculty',@dydtdatalinitemId),
    ('campus', 'Campus',@dydtdatalinitemId);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230508184955__Update_PostgraduateManaStudDataprovider () $$
DROP PROCEDURE IF EXISTS V20230508184955__Update_PostgraduateManaStudDataprovider $$
DELIMITER ;