DELIMITER $$
DROP PROCEDURE IF EXISTS V20230526163958__Create_business_rule_period_mapping $$
CREATE PROCEDURE V20230526163958__Create_business_rule_period_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_period_mapping')) THEN 
CREATE TABLE `business_rule_period_mapping` (
`id` BIGINT NOT NULL AUTO_INCREMENT,
  `businessRuleId` BIGINT NOT NULL,
  `academyLocationId` BIGINT NOT NULL,
  `programId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `periodId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_bisunnes_rule_idx_idx` (`businessRuleId` ASC) ,
  INDEX `fk_academy_location_idx_idx` (`academyLocationId` ASC) ,
  INDEX `fk_program_idx_idx` (`programId` ASC) ,
  INDEX `fk_batch_idx_idx` (`batchId` ASC) ,
  INDEX `fk_period_idx_idx` (`periodId` ASC) ,
  CONSTRAINT `fk_business_rule_idx`
    FOREIGN KEY (`businessRuleId`)
    REFERENCES `business_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_academy_location_idx`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_idx`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_batch_idx`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_period_idx`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_business_rule_period_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
);
END IF; 

END $$
CALL V20230526163958__Create_business_rule_period_mapping () $$ 
DROP PROCEDURE IF EXISTS V20230526163958__Create_business_rule_period_mapping $$ 
DELIMITER ;