DELIMITER $$
DROP PROCEDURE IF EXISTS V20230526174920__Insert_Student_IDCard_RRU $$
CREATE PROCEDURE V20230526174920__Insert_Student_IDCard_RRU()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STUDENT_ID_CARD_RRU')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'STUDENT_ID_CARD_RRU', 'RRU Student Id card', 'STUDENT_ID_CARD_RRU.png', 'CommonReport_STUDENT_ID_CARD_RRU.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'STUDENT_ID_CARD_RRU.jasper', 'AcademiaLogo.png');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='STUDENT_ID_CARD_RRU'))) THEN

	set @studentIDCard = (select id from report_template where templateCode ='STUDENT_ID_CARD_RRU');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@studentIDCard, 'TRANS_PROGRAM', 'Program', '1', NOW()),
	(@studentIDCard, 'TRANS_ENROLLMENT_NO', 'Enrollment No.', '1', NOW()),
	(@studentIDCard, 'TRANS_CONTACT_NO', 'Contact No.', '1', NOW()),
	(@studentIDCard, 'TRANS_DATE_OF_BIRTH', 'Date of Birth', '1', NOW()),
    (@studentIDCard, 'TRANS_VALID_THROUGH', 'Valid Through', '1', NOW()),
    (@studentIDCard, 'TRANS_BLOOD_GROUP', 'Blood Group', '1', NOW()),
    (@studentIDCard, 'TRANS_ADDRESS', 'Address', '1', NOW()),
    (@studentIDCard, 'TRANS_REGISTRAR', 'Registrar', '1', NOW()),
    (@studentIDCard, 'TRANS_INSTRUCTIONS', 'Instructions', '1', NOW()),
    (@studentIDCard, 'TRANS_NOTE', 'Please Surrender this card on Expiry its loss should be reported immediately to Academic Section RRU.', '1', NOW()),
	(@studentIDCard, 'TRANS_THIS_CARD_IS_THE_PROPERTY_OF_RRU', 'This Card is the property of RRU', '1', NOW()),
    (@studentIDCard, 'TRANS_IS_EMERGENCY_CALL', 'IS EMERGENCY CALL', '1', NOW()),
    (@studentIDCard, 'TRANS_BAR_CODE', 'Bar code', '1', NOW()),
    (@studentIDCard, 'TRANS_PHONE_NUMBER', 'Ph.', '1', NOW()),
    (@studentIDCard, 'TRANS_FAX', 'Fax.', '1', NOW()),
	(@studentIDCard, 'TRANS_SID', 'Student Identity Card', '1', NOW());
  END IF;
END $$
CALL V20230526174920__Insert_Student_IDCard_RRU() $$
DROP PROCEDURE IF EXISTS V20230526174920__Insert_Student_IDCard_RRU $$
DELIMITER ;