DELIMITER $$
DROP PROCEDURE IF EXISTS V20230618163131__Create_business_rule_committe_mapping $$
CREATE PROCEDURE V20230618163131__Create_business_rule_committe_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_committe_mapping')) THEN 
CREATE TABLE `business_rule_committe_mapping` (
`id` BIGINT NOT NULL AUTO_INCREMENT,
  `busiRuleId` BIGINT NOT NULL,
  `committeeId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_busi_rule_idx_idx` (`busiRuleId` ASC) ,
  INDEX `fk_committee_idx_idx` (`committeeId` ASC) ,
 CONSTRAINT `busiRuleId`
    FOREIGN KEY (`busiRuleId`)
    REFERENCES `business_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `committeeId`
    FOREIGN KEY (`committeeId`)
    REFERENCES `committee` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_business_rule_committe_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
  );
END IF; 

END $$
CALL V20230618163131__Create_business_rule_committe_mapping () $$ 
DROP PROCEDURE IF EXISTS V20230618163131__Create_business_rule_committe_mapping $$ 
DELIMITER ;