DELIMITER $$
DROP PROCEDURE IF EXISTS V20230620003308__Create_StudentPassportDetailDocumentTable $$
CREATE PROCEDURE V20230620003308__Create_StudentPassportDetailDocumentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_passport_detail_document')) THEN 
CREATE TABLE `student_passport_detail_document`(  
  `id`BIGINT(20) NOT NULL AUTO_INCREMENT,
  `studentPassportDetailId` BIGINT(20) NOT NULL,
  `documentId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT `student_passport_detail_document_FK` FOREIGN KEY (`studentPassportDetailId`) REFERENCES student_passport_detail(`id`),
  CONSTRAINT `student_passport_detail_document_documentId_FK` FOREIGN KEY (`documentId`) REFERENCES documents(`id`),
  CONSTRAINT `student_passport_detail_document_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES users(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF;

END $$
CALL V20230620003308__Create_StudentPassportDetailDocumentTable () $$ 
DROP PROCEDURE IF EXISTS V20230620003308__Create_StudentPassportDetailDocumentTable $$ 
DELIMITER ;