DELIMITER $$
DROP PROCEDURE IF EXISTS V20230707151016__Create_programXferMultiReason $$
CREATE PROCEDURE V20230707151016__Create_programXferMultiReason()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_transfer_request_multiple_reason')) THEN 
 CREATE TABLE `program_transfer_request_multiple_reason` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `programTransferRequestDetailId` BIGINT(20) NOT NULL,
  `programTransferReasonId` BIGINT(20) NULL,
  `reasonRemark` longtext NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_prog_transfer_multiple_reason_request_detail_idx` (`programTransferRequestDetailId` ASC),
  INDEX `fk_prog_transfer_request_multiple_reason_pw_reason_idx` (`programTransferReasonId` ASC),
  INDEX `fk_prog_transfer_request_multiple_reason_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_prog_transfer_multiple_reason_transferRequestDetail_id`
    FOREIGN KEY (`programTransferRequestDetailId`)
    REFERENCES `program_xfer_request_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_prog_transfer_request_multiple_reason_pw_reason_id`
    FOREIGN KEY (`programTransferReasonId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_program_transfer_request_multiple_reasons_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;  

END $$
CALL V20230707151016__Create_programXferMultiReason () $$ 
DROP PROCEDURE IF EXISTS V20230707151016__Create_programXferMultiReason $$ 
DELIMITER ;