DELIMITER $$
DROP PROCEDURE IF EXISTS V20230714124123__Create_UsageReportEmailConfiguration $$
CREATE PROCEDURE V20230714124123__Create_UsageReportEmailConfiguration()
BEGIN
SET SQL_SAFE_UPDATES = 0;
-- --Drop Table------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='usage_report_email_configuration')) THEN 
drop table usage_report_email_configuration;
END IF;

IF EXISTS ((SELECT * FROM standard_master WHERE masterName = 'USAGE_REPORT_EMAIL_CONFIGURATION')) THEN
DELETE FROM standard_master_items where standardMasterId=(SELECT id FROM standard_master WHERE masterName = 'USAGE_REPORT_EMAIL_CONFIGURATION');
DELETE FROM standard_master WHERE masterName = 'USAGE_REPORT_EMAIL_CONFIGURATION';
END IF;
-- --------------------------------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='usage_report_email_conf_drop_down')) THEN 
CREATE TABLE `usage_report_email_conf_drop_down`
( 
`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
`code` VARCHAR(255) NOT NULL,
`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP, 
`lastUpdatedBy` BIGINT(20) NOT NULL,
 PRIMARY KEY (`id`), 
CONSTRAINT `usage_report_email_conf_drop_downlastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=INNODB CHARSET=utf8 COLLATE=utf8_general_ci;
INSERT INTO `usage_report_email_conf_drop_down` (`id`, `code`, `lastUpdatedBy`) VALUES ('1', 'Internal', '1'); 
INSERT INTO `usage_report_email_conf_drop_down` (`id`, `code`, `lastUpdatedBy`) VALUES ('2', 'External', '1');
END IF; 
-- ------------ RE-V2D-380438 --------------------------------------------------------------------------------------------------------------------------------------------------
 
-- ----Create Table------------------------------------------------------------------------------------------------------------------------------------------ 
IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='usage_report_email_configuration')) THEN 
CREATE TABLE `usage_report_email_configuration` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`codeId` BIGINT(20) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `usage_report_email_configuration_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
  CONSTRAINT `usage_report_email_configurationId_FK` FOREIGN KEY (`codeId`) REFERENCES `usage_report_email_conf_drop_down`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 
-- Create with this syntax for OSM Using 'MASTER_WITH_AL'------------------------------------------------------------------------------------------------------------------------------------------------


SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'USAGE_REPORT_EMAIL_CONFIGURATION')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'usage_report_email_configuration','USAGE_REPORT_EMAIL_CONFIGURATION','tools & services','MASTER_WITH_AL',0,0,NULL,1,@currentTimeStamp);
END IF;
-- ---Code drop down column----------------------------------------------------------------------------------------------------------------------------------------------

IF  EXISTS ((select * from standard_master where tableName = 'usage_report_email_configuration')) THEN 
 SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,
`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES
('codeId', 'CODE_ID', @standardMasterMaxId, 'Varchar', '1', 1, 'usage_report_email_conf_drop_down', 'id','code', 0, 0, 0, '1', SYSDATE()),
('itemValue', 'VALUE', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE());
END IF; 


-- ------------------TRANSLATION------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'USAGE_REPORT_EMAIL_CONFIGURATION')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('masterNames', 'USAGE_REPORT_EMAIL_CONFIGURATION', 'USAGE REPORT EMAIL CONFIGURATION','Usage Report Email Configuration','Gebruiksverslag-e-poskonfigurasie','Cấu hình email báo cáo sử dụng',now(),1);
END IF;
SET SQL_SAFE_UPDATES = 1;
-- ----------------------------------------------------------------------------------------------------------------------------------------------
END $$ 
CALL V20230714124123__Create_UsageReportEmailConfiguration () $$ 
DROP PROCEDURE IF EXISTS V20230714124123__Create_UsageReportEmailConfiguration $$ 
DELIMITER ;