DELIMITER $$
DROP PROCEDURE IF EXISTS V20230714173517__Create_DailyUsageReportFromEmailCongf $$
CREATE PROCEDURE V20230714173517__Create_DailyUsageReportFromEmailCongf()
BEGIN

IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='daily_usage_report_from_email_conf')) THEN 
CREATE TABLE daily_usage_report_from_email_conf(
	id BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
	userName VARCHAR(255),
	password VARCHAR(255),
	senderEmailAddress VARCHAR(255),
	clientImageUrl VARCHAR(255),
	host VARCHAR(255),
	port VARCHAR(255),
	isActive BIT(1),
    isDefault BIT(1),
	lastUpdatedBy BIGINT(20),
	lastUpdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
);
END IF;
-- ------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'DAILY_USAGE_REPORT_FROM_EMAIL_CONF')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'daily_usage_report_from_email_conf','DAILY_USAGE_REPORT_FROM_EMAIL_CONF','tools & services','MASTER_WITH_AL',0,0,NULL,1,@currentTimeStamp);
END IF;
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,
`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES 
('userName', 'USER_NAME', @standardMasterMaxId+1, 'Varchar', '1', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('password', 'PASSWORD', @standardMasterMaxId+1, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('senderEmailAddress', 'SENDERE_MAIL_ADDRESS', @standardMasterMaxId+1, 'Varchar', '3', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('clientImageUrl', 'CLIENT_IMAGE_URL', @standardMasterMaxId+1, 'Varchar', '3', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('host', 'HOST', @standardMasterMaxId+1, 'Varchar', '4', 0, NULL, NULL,NULL, 0, 0, 1, '1', SYSDATE()),
('port', 'PORT', @standardMasterMaxId+1, 'Varchar', '5', 0, NULL, NULL,NULL, 0, 0, 1, '1', SYSDATE()),
('isActive', 'IS_ACTIVE', @standardMasterMaxId+1, 'Boolean', '6', 0, NULL, NULL,NULL, 0, 0, 1, '1', SYSDATE()),
('isDefault', 'IS_DEFAULT', @standardMasterMaxId+1, 'Boolean', '7', 0, NULL, NULL,NULL, 0, 0, 1, '1', SYSDATE());
-- ------------------TRANSLATION------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'DAILY_USAGE_REPORT_FROM_EMAIL_CONF')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('masterNames', 'DAILY_USAGE_REPORT_FROM_EMAIL_CONF', 'DAILY USAGE REPORT FROM EMAIL CONF','Daily Usage Report From Email Conf','Daaglikse Gebruik Verslag Van E-pos Conf','Báo cáo sử dụng hàng ngày từ Email Conf',now(),1);
END IF;
-- -------

END $$
CALL V20230714173517__Create_DailyUsageReportFromEmailCongf () $$ 
DROP PROCEDURE IF EXISTS V20230714173517__Create_DailyUsageReportFromEmailCongf $$ 
DELIMITER ;