DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726133359__Create_PermitDetailUrlDocTable $$
CREATE PROCEDURE V20230726133359__Create_PermitDetailUrlDocTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='permit_detail_url_document')) THEN 
CREATE TABLE `permit_detail_url_document` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `permitDetailId` BIGINT(20) NOT NULL,
    `name` VARCHAR(255) NULL DEFAULT NULL,
    `path` VARCHAR(255) NOT NULL,
    `submissionDate` DATE NULL DEFAULT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    CONSTRAINT `fk_permit_detail_url_document_permitDetailId` FOREIGN KEY (`permitDetailId`) REFERENCES `permit_detail`(`id`),
    CONSTRAINT `fk_permit_detail_url_document_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230726133359__Create_PermitDetailUrlDocTable () $$ 
DROP PROCEDURE IF EXISTS V20230726133359__Create_PermitDetailUrlDocTable $$ 
DELIMITER ;