DELIMITER $$
DROP PROCEDURE IF EXISTS V20230726153113__Create_StudentLanguage $$
CREATE PROCEDURE V20230726153113__Create_StudentLanguage()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_language')) THEN 
CREATE TABLE student_language(
id bigint NOT NULL AUTO_INCREMENT,
language bigint DEFAULT NULL,
personId bigint NOT NULL,
languageExamType bigint DEFAULT NULL,
otherLanguageExamType varchar(255) DEFAULT NULL,
languageExamDate date DEFAULT NULL,
yearOfEducation long DEFAULT NULL,
overAllScore varchar(255) DEFAULT NULL,
isPrimaryLanguage bit(1) DEFAULT NULL,
lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
lastUpdatedBy BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_studentlanguage_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_studentlanguage_language_FK` FOREIGN KEY (`language`) REFERENCES `drop_down`(`id`),
CONSTRAINT `FK_studentlanguage_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_studentlanguage_languageExamType_FK` FOREIGN KEY (`languageExamType`) REFERENCES `drop_down`(`id`)
);
END IF; 

END $$
CALL V20230726153113__Create_StudentLanguage () $$ 
DROP PROCEDURE IF EXISTS V20230726153113__Create_StudentLanguage $$ 
DELIMITER ;