DELIMITER $$
DROP PROCEDURE IF EXISTS V20230728145547__Create_ApplicantHealthDocumentUrl $$
CREATE PROCEDURE V20230728145547__Create_ApplicantHealthDocumentUrl()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_health_document_url')) THEN 
CREATE TABLE IF NOT EXISTS `applicant_health_document_url` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`healthId` bigint DEFAULT NULL,	
	`documentName` VARCHAR(255) DEFAULT NULL,
	`documentUrl` VARCHAR(500) DEFAULT NULL,		
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,	
	PRIMARY KEY (`id`),
	CONSTRAINT `FK_ApplicantHealthDocumentUrl_SU_person` FOREIGN KEY (`healthId`) REFERENCES `applicant_health_details` (`id`),
CONSTRAINT `FK_ApplicantHealthDocumentUrl_SU_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `persons` (`id`))
ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230728145547__Create_ApplicantHealthDocumentUrl () $$ 
DROP PROCEDURE IF EXISTS V20230728145547__Create_ApplicantHealthDocumentUrl $$ 
DELIMITER ;