DELIMITER $$
DROP PROCEDURE IF EXISTS V20230731185034__Create_ApplicantLanguage $$
CREATE PROCEDURE V20230731185034__Create_ApplicantLanguage()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_language')) THEN 
CREATE TABLE applicant_language(
id bigint NOT NULL AUTO_INCREMENT,
language bigint DEFAULT NULL,
applicantPersonId bigint NOT NULL,
languageExamType bigint DEFAULT NULL,
otherLanguageExamType varchar(255) DEFAULT NULL,
languageExamDate date DEFAULT NULL,
yearOfEducation long DEFAULT NULL,
overAllScore varchar(255) DEFAULT NULL,
isPrimaryLanguage bit(1) DEFAULT NULL,
lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
lastUpdatedBy BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_applicantlanguage_person` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
CONSTRAINT `FK_applicantlanguage_language_FK` FOREIGN KEY (`language`) REFERENCES `drop_down`(`id`),
CONSTRAINT `FK_applicantlanguage_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_applicantlanguage_languageExamType_FK` FOREIGN KEY (`languageExamType`) REFERENCES `drop_down`(`id`)
);
END IF; 

END $$
CALL V20230731185034__Create_ApplicantLanguage () $$ 
DROP PROCEDURE IF EXISTS V20230731185034__Create_ApplicantLanguage $$ 
DELIMITER ;