DELIMITER $$
DROP PROCEDURE IF EXISTS V20230823183627__Create_scholarshipAwardeeListSetup $$
CREATE PROCEDURE V20230823183627__Create_scholarshipAwardeeListSetup()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='scholarship_awardee_list_setup')) THEN 
CREATE TABLE `scholarship_awardee_list_setup` (
  `id` BIGINT NOT NULL  AUTO_INCREMENT,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `scholarshipRaiseRequestId` bigint(20) NOT NULL,
  `programId` bigint DEFAULT NULL,
  `studentId` bigint(20) DEFAULT NULL,
  `applicantId` bigint(20) DEFAULT NULL,
  `requesterType` varchar(20) DEFAULT NULL,
  `status` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_sch_awardee_lt_setup_to_scholarship_idx`(`scholarshipId`),
  INDEX `fk_sch_awardee_lt_setup_to_schRequestId_idx` (`scholarshipRaiseRequestId`),
  INDEX `fk_sch_awardee_lt_setup_to_program_idx` (`programId`) ,
  INDEX `fk_sch_awardee_lt_setup_to_student_idx` (`studentId`) ,
  INDEX `fk_sch_awardee_lt_setup_to_applicant_idx` (`applicantId`) ,
  INDEX `fk_sch_awardee_lt_setup_to_user_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_sch_awardee_lt_setup_to_scholarship_idx` 
	FOREIGN KEY (`scholarshipId`) 
	REFERENCES `scholarship`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_sch_awardee_lt_setup_to_schRequestId_idx`
	FOREIGN KEY (`scholarshipRaiseRequestId`)
	REFERENCES `scholarship_raise_request` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_sch_awardee_lt_setup_to_program_idx`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_sch_awardee_lt_setup_to_student_idx`
    FOREIGN KEY (`studentId`)
    REFERENCES `students` (`userId`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_sch_awardee_lt_setup_to_applicant_idx`
    FOREIGN KEY (`applicantId`)
    REFERENCES `application` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
     CONSTRAINT `fk_sch_awardee_lt_setup_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20230823183627__Create_scholarshipAwardeeListSetup () $$ 
DROP PROCEDURE IF EXISTS V20230823183627__Create_scholarshipAwardeeListSetup $$ 
DELIMITER ;