DELIMITER $$
DROP PROCEDURE IF EXISTS V20230828144858__Update_AttendanceListDataGrid $$
CREATE PROCEDURE V20230828144858__Update_AttendanceListDataGrid()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="PROGRAM" )) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','PROGRAM','Program','Program',now(),1);
END IF;
IF EXISTS ((select * from data_grid where gridName="Academia.view.attendance.StudentAttendanceGrid" and portalId=1)) THEN 
UPDATE `data_grid` SET `jsonObject`=
'[{"id":null,"columnName":"SNO","dataIndex":"","columnVisibility":"SHOW","sequence":1,"mandatory":true},
{"id":null,"columnName":"ADMISSION_CODE","dataIndex":"admissionCode","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"STUDENT_CODE","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"STUDENT_FIRST_NAME","dataIndex":"firstName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
{"id":null,"columnName":"STUDENT_MIDDLE_NAME","dataIndex":"middleName","columnVisibility":"HIDE","sequence":6,"mandatory":false},
{"id":null,"columnName":"STUDENT_LAST_NAME","dataIndex":"lastName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
{"id":null,"columnName":"PROGRAM","dataIndex":"programName","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"PRESENT","dataIndex":"present","columnVisibility":"SHOW","sequence":9,"mandatory":true},
{"id":null,"columnName":"ABSENT","dataIndex":"absent","columnVisibility":"SHOW","sequence":10,"mandatory":true},
{"id":null,"columnName":"OTHERS","dataIndex":"attendanceStatus","columnVisibility":"SHOW","sequence":11,"mandatory":true},
{"id":null,"columnName":"REMARKS","dataIndex":"comment","columnVisibility":"SHOW","sequence":12,"mandatory":false}]'
WHERE gridName="Academia.view.attendance.StudentAttendanceGrid" and portalId=1;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230828144858__Update_AttendanceListDataGrid () $$
DROP PROCEDURE IF EXISTS V20230828144858__Update_AttendanceListDataGrid $$
DELIMITER ;