DELIMITER $$
DROP PROCEDURE IF EXISTS V20231030123839__Create_RegistrationContractEmergency $$
CREATE PROCEDURE V20231030123839__Create_RegistrationContractEmergency()
BEGIN

IF EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO')) THEN 
IF NOT EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='EMERGENCY_CONTACT_NAME_CONTACT_NUMBER')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT MIN(dataProviderId) FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'EMERGENCY_CONTACT_NAME_CONTACT_NUMBER', '9',null, '1', '0', 
"select 
concat(per.emergencyFirstName,' ',per.emergencyLastName) as EMERGENCY_CONTACT_NAME,
concat(per.emergencyMobileCountryCode,'-',per.emergencyMobileNumber) as EMERGENCY_CONTACT_NUMBER,
IFNULL(
        (SELECT CONCAT('Yes-', ffrt.itemValue)
         FROM persons per
         JOIN students st ON st.personId = per.id
         JOIN admission ad ON ad.studentId = st.userId
         LEFT JOIN service_requests sr ON sr.requester = st.userId
         LEFT JOIN free_form_request_details ffrd ON ffrd.serviceRequestId = sr.id
         LEFT JOIN free_form_request_types ffrt ON ffrd.freeFormRequestTypeId = ffrt.id
         LEFT JOIN free_form_request_categories ffrc ON ffrc.id = ffrd.freeFormRequestCategoryId
         LEFT JOIN request_status rs ON rs.id = sr.requestStatusId
         WHERE ad.id = admi.id
           AND rs.itemCode NOT IN ('Rejected', 'Assigned', 'Withdrawn', 'Cancelled', 'Pending')
           AND ffrc.itemValue LIKE '%Bursary%'
           AND sr.whetherDeleted = false
           AND whetherWithdrawn = false limit 1
        ),
        'No'
    ) AS BURSARY_APPLICATION_CATEGORY,
    IFNULL(
        (SELECT CONCAT('Yes-', ffrt.itemValue)
         FROM persons per
         JOIN students st ON st.personId = per.id
         JOIN admission ad ON ad.studentId = st.userId
         LEFT JOIN service_requests sr ON sr.requester = st.userId
         LEFT JOIN free_form_request_details ffrd ON ffrd.serviceRequestId = sr.id
         LEFT JOIN free_form_request_types ffrt ON ffrd.freeFormRequestTypeId = ffrt.id
         LEFT JOIN free_form_request_categories ffrc ON ffrc.id = ffrd.freeFormRequestCategoryId
         LEFT JOIN request_status rs ON rs.id = sr.requestStatusId
         WHERE ad.id = admi.id
           AND rs.itemCode NOT IN ('Rejected', 'Assigned','Withdrawn', 'Cancelled', 'Pending')
           AND ffrc.itemValue LIKE '%Sports Club%'
           AND sr.whetherDeleted = false
           AND whetherWithdrawn = false limit 1
        ),
        'No'
    ) AS AD_HOC_FEES_AND_SERVICES
from persons per
join students st on st.personId = per.id 
join admission admi on admi.studentId=st.userId", 
    'PRM_ADMISSION_ID', 
	'EMERGENCY_CONTACT_NAME,EMERGENCY_CONTACT_NUMBER,BURSARY_APPLICATION_CATEGORY,AD_HOC_FEES_AND_SERVICES',
"where admi.id=PRM_ADMISSION_ID and admi.activeStatus=TRUE",false);


INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('EMERGENCY_CONTACT_NAME', 'Emergency Contact Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('EMERGENCY_CONTACT_NUMBER', 'Emergency Contact Number',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('BURSARY_APPLICATION_CATEGORY', 'Bursary Application Category',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('AD_HOC_FEES_AND_SERVICES', 'Ad Hoc Fees & Services',@dydtdatalinitemId+1);
END IF; 
END IF; 
END $$
CALL V20231030123839__Create_RegistrationContractEmergency () $$ 
DROP PROCEDURE IF EXISTS V20231030123839__Create_RegistrationContractEmergency $$ 
DELIMITER ;