DELIMITER $$
DROP PROCEDURE IF EXISTS V20231031215844__Create_schDocReSubmissionStudenttEvent $$
CREATE PROCEDURE V20231031215844__Create_schDocReSubmissionStudenttEvent()
BEGIN

-- START SCH_DOCUMENT_RE_SUBMISSION_STUDENT EVENT 
IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SCH_DOCUMENT_RE_SUBMISSION_STUDENT');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SCH_DOCUMENT_RE_SUBMISSION_STUDENT', 'Scholarship Document Re-submission - Student', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Scholarship Document Re-submission - Student');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SCH_DOCUMENT_RE_SUBMISSION_STUDENT_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SCH_DOCUMENT_RE_SUBMISSION_STUDENT_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SCH_DOCUMENT_RE_SUBMISSION_STUDENT_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM scholarship_nominate_or_award T1 WHERE T1.id IN (namedParams)",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT DISTINCT
    T1.id AS ID,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS FIRST_NAME,
    T3.middleName AS MIDDLE_NAME,
    T3.lastName AS LAST_NAME,
    T2.code AS STUDENT_ID,
    T2.emailId AS EMAIL_ID,
    CURDATE() AS CURRENT_DATE_TODAY,
    T3.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
    T29.programName AS PROGRAM,
    T28.batchName AS BATCH,
    T30.printName AS PERIOD,
    T33.seatName AS SEAT_TYPE,
    T8.scholarshipCode AS SCHOLARSHIP_ID,
    T8.scholarshipName AS SCHOLARSHIP_NAME,
    T8.scholarshipCategory AS SCHOLARSHIP_CATEGORY,
    T1.amount AS SCHOLARSHIP_AMOUNT,
    T26.printName AS INSPECTION_BY,
    T25.inspectionDate AS INSPECTION_DATE,
    T25.scholarshipDocumentName AS DOCUMENT_NAME,
    T25.remark AS DOCUMENT_REMARK,
    T12.displayName AS AL,
    T13.addressText AS CURRENT_ADDRESS,
    T14.cityName AS CITY,
    T15.countryName AS COUNTRY,
    T13.pincode AS PIN_CODE
FROM
    scholarship_nominate_or_award T1
        LEFT OUTER JOIN
    students T20 ON T1.studentId = T20.userId
        LEFT OUTER JOIN
    users T2 ON T20.userId = T2.id
        LEFT OUTER JOIN
    persons T3 ON T20.personId = T3.id
        LEFT OUTER JOIN
    scholarship T8 ON T8.id = T1.scholarshipId
        LEFT OUTER JOIN
    accounting_year T9 ON T9.id = T1.accountingYearId
        LEFT OUTER JOIN
    user_academy_locations T21 ON T21.id = T2.id
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T21.academyLocationId
        LEFT OUTER JOIN
    person_addresses T22 ON T22.personId = T3.id
        LEFT OUTER JOIN
    address T13 ON T22.addressId = T13.id
        LEFT OUTER JOIN
    city T14 ON T14.id = T13.cityId
        LEFT OUTER JOIN
    country T15 ON T15.id = T13.countryId
        LEFT OUTER JOIN
    address_type T16 ON T16.id = T13.addressTypeId
        AND T16.code = 'CRNT'
        AND T16.addressCategory = 'PERSON'
        LEFT OUTER JOIN
    scholarship_document_student T25 ON T25.scholarshipNominateOrAwardId = T1.id
        LEFT OUTER JOIN
    users T26 ON T26.id = T25.inspectionBy
        LEFT OUTER JOIN
    admission T31 ON T31.studentId = T20.userId
        LEFT OUTER JOIN
    program_batch_students T27 ON T27.admissionId = T31.id
        LEFT OUTER JOIN
    batches T28 ON T28.id = T27.programBatchId
        LEFT OUTER JOIN
    programs T29 ON T29.id = T28.programId
        LEFT OUTER JOIN
    prog_batch_period_config T30 ON T30.id = T27.progBatchPeriodConfigId
        LEFT OUTER JOIN
    prog_batch_seat_config T32 ON T32.id = T27.progBatchSeatConfigId
        LEFT OUTER JOIN
    seat_types T33 ON T33.id = T32.seatTypeId
 LEFT OUTER JOIN
     scholarship_document T35 ON T35.id=T25.scholarshipDocumentId
WHERE
    T25.documentStatus = 'RE_SUBMIT'
        AND T27.isCurrentPeriod = TRUE
        AND T27.isCurrentSection = TRUE
        AND T27.isPeriodCompleted = FALSE
        AND T27.exitDate IS NULL and T1.id IN (namedParams)
and T35.applicability='MANDATORY'",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "CURRENT_DATE_TODAY",
            "resultKey": "CURRENT_DATE_TODAY",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "externalSysRefOne",
            "resultKey": "STUDENT_EXTERNAL_REFERENCE_NUMBER_1",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "seatName",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9
        },{
            "id": 11,
            "value": "scholarshipCode",
            "resultKey": "SCHOLARSHIP_ID",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "scholarshipName",
            "resultKey": "SCHOLARSHIP_NAME",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "scholarshipCategory",
            "resultKey": "SCHOLARSHIP_CATEGORY",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "amount",
            "resultKey": "SCHOLARSHIP_AMOUNT",
            "displayCode": "",
            "displayOrder": 13
        },{
            "id": 15,
            "value": "printName",
            "resultKey": "INSPECTION_BY",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "inspectionDate",
            "resultKey": "INSPECTION_DATE",
            "displayCode": "",
            "displayOrder": 15
        },
		
		{
            "id": 17,
            "value": "scholarshipDocumentName",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "remark",
            "resultKey": "DOCUMENT_REMARK",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "displayName",
            "resultKey": "AL",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "addressText",
            "resultKey": "CURRENT_ADDRESS",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "cityName",
            "resultKey": "CITY",
            "displayCode": "",
            "displayOrder": 20
        },
		{
            "id": 22,
            "value": "countryName",
            "resultKey": "COUNTRY",
            "displayCode": "",
            "displayOrder": 21
        },
		{
            "id": 23,
            "value": "pincode",
            "resultKey": "PIN_CODE",
            "displayCode": "",
            "displayOrder": 22
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SCH_DOCUMENT_RE_SUBMISSION_STUDENT');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SCH_DOCUMENT_RE_SUBMISSION_STUDENT_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Scholarship Document Re-submission - Student',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Scholarship Document Re-submission - Student',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Scholarship Document Re-submission - Student','<!DOCTYPE html>
<html>
<head>
    <title></title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            border: 1px solid #000; /* Add an outer border to the table */
        }

        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #000; /* Add both horizontal and vertical lines between cells */
        }
    </style>
    </head>
    <body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1135.0">
        Dear $recipientData["studentPrintName"] ,<br>

        Please note that we have reviewed your acceptance documentation. The following documents require your attention. Kindly note the following:

        <table>
            <tr>
                <th>documentName</th>
                <th>documentRemark</th>
                <th>inspectionDate</th>
                <th>inspectionBy</th>
            </tr>
            #foreach ($Data in $recipientData["documentResubmissionStudent"])
            <tr>
                <td>$Data.documentName</td>
                <td>$Data.documentRemark</td>
                <td>$Data.inspectionDate</td>
                <td>$Data.inspectionBy</td>
            </tr>
            #end
        </table>

        Please ensure that you attend to the abovementioned instructions and resubmit the relevant documents.

        Kind regards,
    </body>
</html>
');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2',NULL,'');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+3,@msgtemplateconfigId+1,'4','Scholarship Document Re-submission - Student','<!DOCTYPE html>
<html>
<head>
    <title></title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            border: 1px solid #000; /* Add an outer border to the table */
        }

        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #000; /* Add both horizontal and vertical lines between cells */
        }
    </style>
    </head>
    <body data-gr-ext-installed="" data-new-gr-c-s-check-loaded="14.1135.0">
        Dear $recipientData["studentPrintName"] ,<br>

        Please note that we have reviewed your acceptance documentation. The following documents require your attention. Kindly note the following:

        <table>
            <tr>
                <th>documentName</th>
                <th>documentRemark</th>
                <th>inspectionDate</th>
                <th>inspectionBy</th>
            </tr>
            #foreach ($Data in $recipientData["documentResubmissionStudent"])
            <tr>
                <td>$Data.documentName</td>
                <td>$Data.documentRemark</td>
                <td>$Data.inspectionDate</td>
                <td>$Data.inspectionBy</td>
            </tr>
            #end
        </table>

        Please ensure that you attend to the abovementioned instructions and resubmit the relevant documents.

        Kind regards,
    </body>
</html>
');
 


-- End Messaging for SCH_DOCUMENT_RE_SUBMISSION_STUDENT Event
END IF;   

END $$
CALL V20231031215844__Create_schDocReSubmissionStudenttEvent () $$ 
DROP PROCEDURE IF EXISTS V20231031215844__Create_schDocReSubmissionStudenttEvent $$ 
DELIMITER ;