DELIMITER $$
DROP PROCEDURE IF EXISTS V20231105223354__Insert_INDUS_Hall_Ticket $$
CREATE PROCEDURE V20231105223354__Insert_INDUS_Hall_Ticket()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'INDUS_HALL_TICKET')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('8', 'INDUS_HALL_TICKET', 'INDUS Hall Ticket', 'INDUS_HALL_TICKET.png', 'CommonReport_INDUS.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'INDUS_HALL_TICKET.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'INDUS_HALL_TICKET')) THEN 
set @IndusHallTicket = (select id from report_template where templateCode ='INDUS_HALL_TICKET');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@IndusHallTicket, 'TRANS_SESSION', 'Session', '1', NOW()),
(@IndusHallTicket, 'TRANS_DELIMITER', ':', '1', NOW()),
(@IndusHallTicket, 'TRANS_SCHOOL', 'Name of the School', '1', NOW()),
(@IndusHallTicket, 'TRANS_EXAMINATION', 'Name of the Examination', '1', NOW()),
(@IndusHallTicket, 'TRANS_STUDENT', 'Name of the Student', '1', NOW()),
(@IndusHallTicket, 'TRANS_MOTHERS_NAME', 'Mother’s Name', '1', NOW()),
(@IndusHallTicket, 'TRANS_GENDER', 'Gender', '1', NOW()),
(@IndusHallTicket, 'TRANS_EXAMINEE_CATEGORY', 'Examinee Category', '1', NOW()),	
(@IndusHallTicket, 'TRANS_ROLL_NO', 'Roll No.', '1', NOW()),
(@IndusHallTicket, 'TRANS_REGISTRATION', 'Registration No.', '1', NOW()),
(@IndusHallTicket, 'TRANS_MEDIUM', 'Medium', '1', NOW()),
(@IndusHallTicket, 'TRANS_MEDIUM_VALUE', 'ENGLISH', '1', NOW()),
(@IndusHallTicket, 'TRANS_SRNO', 'Sr. No.', '1', NOW()),
(@IndusHallTicket, 'TRANS_COURSE_NAME', 'Course Name', '1', NOW()),
(@IndusHallTicket, 'TRANS_COURSE_CODE', 'Course Code', '1', NOW()),
(@IndusHallTicket, 'TRANS_EXAMINATION_DATES', 'Date of Examination', '1', NOW()),
(@IndusHallTicket, 'TRANS_EXAMINATION_TIME', 'Timings of Examinations', '1', NOW()),
(@IndusHallTicket, 'TRANS_INVIGILATOR', 'Signature of Invigilator', '1', NOW()),
(@IndusHallTicket, 'TRANS_CENTER', 'Centre Name:', '1', NOW()),
(@IndusHallTicket, 'TRANS_TEXT', 'ADMIT CARD FOR THE EXAMINATIONS/RE-EXAMINATIONS', '1', NOW()),
(@IndusHallTicket, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', NOW()),
(@IndusHallTicket, 'TRANS_COURSES_OFFERED', 'Courses Offered/ Schedule:', '1', NOW()),
(@IndusHallTicket, 'TRANS_SRNO', 'Sr. No.', '1', NOW()),
(@IndusHallTicket, 'TRANS_SEAL', 'Seal', '1', NOW()),
(@IndusHallTicket, 'TRANS_EXAMINATION_CONTROLLER', 'Controller of Examinations', '1', NOW());
END IF; 

END $$
CALL V20231105223354__Insert_INDUS_Hall_Ticket() $$
DROP PROCEDURE IF EXISTS V20231105223354__Insert_INDUS_Hall_Ticket $$
DELIMITER ;