DELIMITER $$
DROP PROCEDURE IF EXISTS V20231220203540__Create_ApplicaitonAcademicTopics $$
CREATE PROCEDURE V20231220203540__Create_ApplicaitonAcademicTopics()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_academic_topics')) THEN 
CREATE TABLE `application_academic_topics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicationId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `academicSubTopicId` bigint(20) NOT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `description` LONGTEXT NULL DEFAULT NULL,
   `status` VARCHAR(50) NULL DEFAULT NULL ,
   `createdBy` BIGINT NULL DEFAULT NULL,
   `createdAt` DATETIME NULL DEFAULT NULL,
  `updatedBy` BIGINT NULL DEFAULT NULL,
  `updatedAt` DATETIME NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_application_academic_topics_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_application_academic_topics_applicationId_idx` (`applicationId`),
  KEY `fk_application_academic_topics_batchId_idx` (`batchId`),
  KEY `fk_application_academic_topics_periodId_idx` (`periodId`),
  KEY `fk_application_academic_topics_academicSubTopicId_idx` (`academicSubTopicId`),
  CONSTRAINT `fk_application_academic_topics_admissionId` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`),
  CONSTRAINT `fk_application_academic_topics_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_application_academic_topics_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_application_academic_topics_academicSubTopicId_idx` FOREIGN KEY (`academicSubTopicId`) REFERENCES `academic_sub_topics` (`id`),
  CONSTRAINT `fk_application_academic_topics_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_application_academic_topics_createBy`
	FOREIGN KEY (`createdBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
    CONSTRAINT `fk_application_academic_topics_updatedBy`
	FOREIGN KEY (`updatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20231220203540__Create_ApplicaitonAcademicTopics () $$ 
DROP PROCEDURE IF EXISTS V20231220203540__Create_ApplicaitonAcademicTopics $$ 
DELIMITER ;