DELIMITER $$
DROP PROCEDURE IF EXISTS V20240116171543_Insert_NEWCECOSStudentIdCardReportTemplate $$
CREATE PROCEDURE V20240116171543_Insert_NEWCECOSStudentIdCardReportTemplate()
BEGIN
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'NEW_CECOS_STUDENT_ID_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('7', 'NEW_CECOS_STUDENT_ID_CARD', 'CECOS Student ID Card New', 'NEW_CECOS_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Horizontal_ATMCardSize_NEW.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'STUDENT_ID_CARD_CECOS_NEW.jasper', 'AcademiaLogo.png');
END IF; 

set @NEW_CECOS_STUDENT_ID_CARD = (select max(id) from report_template where templateCode ='NEW_CECOS_STUDENT_ID_CARD');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@NEW_CECOS_STUDENT_ID_CARD and `keyValue` = 'TRANS_STUDENT_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@NEW_CECOS_STUDENT_ID_CARD, 'TRANS_STUDENT_ID', 'Student ID:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@NEW_CECOS_STUDENT_ID_CARD and `keyValue` = 'TRANS_COURSE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@NEW_CECOS_STUDENT_ID_CARD, 'TRANS_COURSE', 'Course:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@NEW_CECOS_STUDENT_ID_CARD and `keyValue` = 'TRANS_END_DATE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@NEW_CECOS_STUDENT_ID_CARD, 'TRANS_END_DATE', 'End Date:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@NEW_CECOS_STUDENT_ID_CARD and `keyValue` = 'TRANS_INTAKE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@NEW_CECOS_STUDENT_ID_CARD, 'TRANS_INTAKE', 'Intake:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@NEW_CECOS_STUDENT_ID_CARD and `keyValue` = 'TRANS_FOUNDER_ID')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@NEW_CECOS_STUDENT_ID_CARD, 'TRANS_FOUNDER_ID', 'Funder ID:', '1', NOW());
END IF;

END $$
CALL V20240116171543_Insert_NEWCECOSStudentIdCardReportTemplate() $$
DROP PROCEDURE IF EXISTS V20240116171543_Insert_NEWCECOSStudentIdCardReportTemplate $$
DELIMITER ;