DELIMITER $$
DROP PROCEDURE IF EXISTS V20240315132134__Update_UpdatePrintCertificateEvent $$
CREATE PROCEDURE V20240315132134__Update_UpdatePrintCertificateEvent()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PRINT_CERTIFICATE_STUDENT_RECIPIENT');
IF EXISTS (((SELECT * FROM dtprovider WHERE `dataProviderName`='PRINT_CERTIFICATE_STUDENT_RECIPIENT'))) THEN 
UPDATE sql_dtprovider
SET sqlQuery="SELECT DISTINCT
	a.studentId AS ID,
    p.programCode AS PROGRAM_CODE,
    p.programName AS PROGRAM_NAME,
    p.programNameToBePrint AS PROGRAM_PRINT_NAME,
    pd.shortCode AS PRIMARY_DEPT_CODE,
    pd.deptName AS PRIMARY_DEPT_NAME,
    psd.shortCode AS SECONDARY_DEPT_CODE,
    psd.deptName AS SECONDARY_DEPT_NAME,
    b.batchName AS BATCH_NAME,
    b.printName AS BATCH_PRINTNAME,
    sal.salutationName AS STUDENT_SALUTATION,
    DATE_FORMAT(DATE(b.startDate), '%d-%m-%Y') AS BATCH_START_DATE,
    DATE_FORMAT(DATE(b.tillDate), '%d-%m-%Y') AS BATCH_TILLDATE,
    ay.itemValue AS INTAKE_YEAR,
    a.code AS ADMISSION_CODE,
    a.studentId AS STUDENT_ID,
    pbpc.programPeriodName AS PERIOD_NAME,
    pbpc.printName AS PERIOD_PRINT_NAME,
    prsn.photoUrl AS IMG_PHOTO_URL,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE,
    u.code AS PERSON_CODE,
    prsn.firstName AS FIRST_NAME,
    prsn.middleName AS MIDDLE_NAME,
    prsn.lastName AS LAST_NAME,
    (CASE
        WHEN (prsn.genderId = 1) THEN 'Male'
        WHEN (prsn.genderId = 2) THEN 'Female'
        WHEN (prsn.genderId = 3) THEN 'Transgender'
        ELSE NULL
    END) AS STUDENT_GENDER,
    cc.itemValue AS CAST_CATEGORY,
    DATE_FORMAT(DATE(prsn.birthDate), '%d-%m-%Y') AS BIRTH_DATE,
    ntn.itemValue AS NATIONALITY,
    rel.itemValue AS RELIGIONS,
    sec.sectionCode AS SECTION_CODE,
    DATE_FORMAT(a.admissionDate, '%d-%m-%Y') AS ADMISSION_DATE,
    TRUNCATE(DATEDIFF(DATE_FORMAT(DATE(NOW()), '%Y-%m-%d'),
                prsn.birthDate) / 365.25,
        0) AS STUDENT_AGE,
    (CASE
        WHEN (prsn.bloodGroup = 'O_PLUS') THEN 'O+'
        WHEN (prsn.bloodGroup = 'O_MINUS') THEN 'O-'
        WHEN (prsn.bloodGroup = 'A_PLUS') THEN 'A+'
        WHEN (prsn.bloodGroup = 'A_MINUS') THEN 'A-'
        WHEN (prsn.bloodGroup = 'B_PLUS') THEN 'B+'
        WHEN (prsn.bloodGroup = 'B_MINUS') THEN 'B-'
        WHEN (prsn.bloodGroup = 'AB_PLUS') THEN 'AB+'
        WHEN (prsn.bloodGroup = 'AB_MINUS') THEN 'AB-'
        ELSE NULL
    END) AS BLOOD_GROUP,
    affUniv.itemValue AS AFFILIATED_UNIVERSITY,
    affUniv.itemValueOtherLanguage AS AFFILIATED_UNIVERSITY_OTHER_LANGUAGE,
    prsn.birth_place AS BIRTH_PLACE,
    prsn.birth_place_language AS BIRTH_PLACE_OTHER_LANGUAGE,
    prsn.printNameOtherLanguage AS PRINT_NAME_OTHER_LANGUAGE,
    p.programNameLanguageOne AS PROGRAM_NAME_LANGUAGE_ONE,
    md.itemValue AS MODE_OF_DELIEVERY,
    md.itemValueOtherLanguage AS MODE_OF_DELIEVERY_OTHER_LANGUAGE,
    dcr.recommendation AS RECOMMENDATION,
    pg.groupName AS PROGRAM_GROUP,
    co.effectiveDate AS EFFECTIVE_PASS_OUT_DATE,
    po.decisionNumber AS DECISION_NUMBER,
    dd.value AS HOME_LANGUAGE,
    prsn.nationalID AS NATIONAL_ID,
    prsn.category AS CATEGORY,
    heqf.itemValue AS NQF_LEVEL,
    p.saqaId AS SAQA_ID,
    REPLACE(b.minProgramCredits, '.0', '') AS NUMBER_OF_CREDITS,
    DATE_FORMAT(DATE(pbpc.programPeriodEnd), '%d %M %Y') AS PERIOD_END_DATE,
    al.displayName AS ACADEMY_LOCATION_DISPLAY_NAME_ADM,
    ad.phoneCountryCode AS AL_PHONE_COUNTRY_CODE_ADM,
    ad.phoneNo AS AL_PHONE_NO_ADM,
    ad.cellCountryCode AS ACADEMY_LOC_CELL_COUNTRY_CODE_ADM,
    ad.cellNo AS ACADEMY_LOC_CELL_NO_ADM,
    addr.addressText AS ADDRESSTEXT_ADM,
    city.cityName AS ADDRESSTEXTCITYNAME_ADM,
    addr.pincode AS ADDRESSTEXTPINCODE_ADM,
    country.countryName AS ADDRESSTEXTCOUNTRYNAME_ADM,
    ad.primaryeEmailId AS ACADEMY_LOC_PRIMARY_EMAIL_ID_ADM,
    prsn.mobileCountryCode AS MOBILECODE_STU,
    prsn.mobileNumber AS MOBILE_NUMBER_STU,
    prsn.emailId AS EMAIL_ID,
    prsn.alternateEmailId AS ALTERNATE_EMAIL_ID,
    u.printName AS STUDENT_PRINT_NAME,
	prsn.mobileNumber AS MOBILE_NO,
    (CASE
        WHEN
            al.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', al.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            al.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', al.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
  c.certificateName as LETTER_NAME
 ,ad.addressText as ACADEMY_LOCATION_ADDR,stdoc.id
FROM
    program_batch_students pbs
        LEFT JOIN
    admission a ON a.id = pbs.admissionId 
        LEFT JOIN
    batches b ON b.id = pbs.programBatchId
        LEFT JOIN
    programs p ON b.programId = p.id
        LEFT JOIN
    intake_year ay ON ay.id = b.intakeYearId
        LEFT JOIN
    department pd ON pd.id = p.programDepartmentId
        LEFT JOIN
    department psd ON psd.id = p.subDepartmentId
        LEFT JOIN
    prog_batch_period_config pbpc ON pbs.progBatchPeriodConfigId = pbpc.id
        LEFT JOIN
    students st ON st.userId = a.studentId
        LEFT JOIN
    persons prsn ON prsn.id = st.personId
        LEFT JOIN
    users u ON u.id = st.userId
        LEFT JOIN
    caste_categories cc ON cc.id = prsn.castCategoryId
        LEFT JOIN
    nationalities ntn ON ntn.id = prsn.nationalityId
        LEFT JOIN
    religions rel ON rel.id = prsn.religionId
        LEFT JOIN
    sections sec ON sec.id = pbs.sectionId
        LEFT JOIN
    salutations sal ON sal.id = prsn.salutationId
        LEFT JOIN
    affiliated_university affUniv ON affUniv.id = p.affiliatedUniversityId
        LEFT JOIN
    mode_of_delivery md ON md.id = p.modeOfDeliveryId
        LEFT JOIN
    degree_classification_batch_mapping dcbm ON dcbm.batchId = b.id
        LEFT JOIN
    degree_classification_remark dcr ON dcr.degreeClassificationId = dcbm.degreeClassificationId
        LEFT JOIN
    program_group pg ON pg.id = p.programGroupId
        LEFT JOIN
    completions co ON co.admissionId = a.id
        AND co.batchId = pbs.programBatchId
        LEFT JOIN
    passing_outs po ON po.completionId = co.id
        LEFT JOIN
    drop_down dd ON dd.id = prsn.homeLanguage
        LEFT JOIN
    heqf_level heqf ON p.heqfLevelId = heqf.id
        INNER JOIN
    academy_location al ON a.academyLocationId = al.id
        LEFT JOIN
    location_addresses la ON al.locationId = la.locationId
        LEFT JOIN
    address ad ON la.addressId = ad.id
        AND ad.addressTypeId = 3
        LEFT OUTER JOIN
    persons per ON st.personId = per.id
        LEFT OUTER JOIN
    person_addresses pa ON per.id = pa.personId
        AND pa.whetherPrimary = TRUE
        LEFT OUTER JOIN
    address addr ON pa.addressId = addr.id
        LEFT OUTER JOIN
    city city ON city.id = addr.cityId
        LEFT OUTER JOIN
    country country ON country.id = city.countryId
        LEFT OUTER JOIN
    `organizations` org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations) 
    LEFT JOIN student_documents stdoc on (stdoc.studentId = a.studentId and stdoc.certificateId is not null )
	LEFT JOIN certificates c on c.id = stdoc.certificateId
WHERE
 a.studentId IN (namedParams) AND pbs.isCurrentPeriod = true AND pbs.isCurrentSection = true AND (pbs.exitDate IS NULL OR a.inactiveReasonCode in(7,9)) ORDER BY stdoc.id DESC
LIMIT 1", jsonString ='{
     "id": 1,
     "searchResultViewColumns": [
     {
            "id": 1,
            "value": "studentId",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },{
            "id": 2,
            "value": "programCode",
            "resultKey": "PROGRAM_CODE",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 2
        },{
            "id": 4,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },{
            "id": 5,
            "value": "shortCode",
            "resultKey": "PRIMARY_DEPT_CODE",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "deptName",
            "resultKey": "PRIMARY_DEPT_NAME",
            "displayCode": "",
            "displayOrder": 5
        },{
            "id": 7,
            "value": "shortCode",
            "resultKey": "SECONDARY_DEPT_CODE",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "deptName",
            "resultKey": "SECONDARY_DEPT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },{
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 8
        },{
            "id": 10,
            "value": "printName",
            "resultKey": "BATCH_PRINTNAME",
            "displayCode": "",
            "displayOrder": 9
        },{
            "id": 11,
            "value": "salutationName",
            "resultKey": "STUDENT_SALUTATION",
            "displayCode": "",
            "displayOrder": 10
        },{
            "id": 12,
            "value": "startDate",
            "resultKey": "BATCH_START_DATE",
            "displayCode": "",
            "displayOrder": 11
        },{
            "id": 13,
            "value": "tillDate",
            "resultKey": "BATCH_TILLDATE",
            "displayCode": "",
            "displayOrder": 12
        },{
            "id": 14,
            "value": "itemValue",
            "resultKey": "INTAKE_YEAR",
            "displayCode": "",
            "displayOrder": 13
        },{
            "id": 15,
            "value": "code",
            "resultKey": "ADMISSION_CODE",
            "displayCode": "",
            "displayOrder": 14
        },{
            "id": 16,
            "value": "studentId",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 15
        },{
            "id": 17,
            "value": "programPeriodName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 16
        },{
            "id": 18,
            "value": "printName",
            "resultKey": "PERIOD_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 17
        },{
            "id": 19,
            "value": "photoUrl",
            "resultKey": "IMG_PHOTO_URL",
            "displayCode": "",
            "displayOrder": 18
        },{
            "id": 20,
            "value": "TODAY_DATE",
            "resultKey": "TODAY_DATE",
            "displayCode": "",
            "displayOrder": 19
        },{
            "id": 21,
            "value": "code",
            "resultKey": "PERSON_CODE",
            "displayCode": "",
            "displayOrder": 20
        },{
            "id": 22,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 21
        },{
            "id": 23,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 22
        },{
            "id": 24,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 23
        },{
            "id": 25,
            "value": "genderId",
            "resultKey": "STUDENT_GENDER",
            "displayCode": "",
            "displayOrder": 24
        },{
            "id": 26,
            "value": "itemValue",
            "resultKey": "CAST_CATEGORY",
            "displayCode": "",
            "displayOrder": 25
        },{
            "id": 27,
            "value": "birthDate",
            "resultKey": "BIRTH_DATE",
            "displayCode": "",
            "displayOrder": 26
        },{
            "id": 28,
            "value": "itemValue",
            "resultKey": "NATIONALITY",
            "displayCode": "",
            "displayOrder": 27
        },{
            "id": 29,
            "value": "itemValue",
            "resultKey": "RELIGIONS",
            "displayCode": "",
            "displayOrder": 28
        },{
            "id": 30,
            "value": "sectionCode",
            "resultKey": "SECTION_CODE",
            "displayCode": "",
            "displayOrder": 29
        },{
            "id": 31,
            "value": "admissionDate",
            "resultKey": "ADMISSION_DATE",
            "displayCode": "",
            "displayOrder": 30
        },{
            "id": 32,
            "value": "birthDate",
            "resultKey": "STUDENT_AGE",
            "displayCode": "",
            "displayOrder": 31
        },{
            "id": 33,
            "value": "bloodGroup",
            "resultKey": "BLOOD_GROUP",
            "displayCode": "",
            "displayOrder": 32
        },{
            "id": 34,
            "value": "itemValue",
            "resultKey": "AFFILIATED_UNIVERSITY",
            "displayCode": "",
            "displayOrder": 33
        },{
            "id": 35,
            "value": "itemValueOtherLanguage",
            "resultKey": "AFFILIATED_UNIVERSITY_OTHER_LANGUAGE",
            "displayCode": "",
            "displayOrder": 34
        },{
            "id": 36,
            "value": "birth_place",
            "resultKey": "BIRTH_PLACE",
            "displayCode": "",
            "displayOrder": 35
        },{
            "id": 37,
            "value": "birth_place_language",
            "resultKey": "BIRTH_PLACE_OTHER_LANGUAGE",
            "displayCode": "",
            "displayOrder": 36
        },{
            "id": 38,
            "value": "printNameOtherLanguage",
            "resultKey": "PRINT_NAME_OTHER_LANGUAGE",
            "displayCode": "",
            "displayOrder": 37
        },{
            "id": 39,
            "value": "programNameLanguageOne",
            "resultKey": "PROGRAM_NAME_LANGUAGE_ONE",
            "displayCode": "",
            "displayOrder": 38
        },{
            "id": 40,
            "value": "itemValue",
            "resultKey": "MODE_OF_DELIEVERY",
            "displayCode": "",
            "displayOrder": 39
        },{
            "id": 41,
            "value": "itemValueOtherLanguage",
            "resultKey": "MODE_OF_DELIEVERY_OTHER_LANGUAGE",
            "displayCode": "",
            "displayOrder": 40
        },{
            "id": 42,
            "value": "recommendation",
            "resultKey": "RECOMMENDATION",
            "displayCode": "",
            "displayOrder": 41
        },{
            "id": 43,
            "value": "groupName",
            "resultKey": "PROGRAM_GROUP",
            "displayCode": "",
            "displayOrder": 42
        },{
            "id": 44,
            "value": "effectiveDate",
            "resultKey": "EFFECTIVE_PASS_OUT_DATE",
            "displayCode": "",
            "displayOrder": 43
        },{
            "id": 45,
            "value": "decisionNumber",
            "resultKey": "DECISION_NUMBER",
            "displayCode": "",
            "displayOrder": 44
        },{
            "id": 46,
            "value": "value",
            "resultKey": "HOME_LANGUAGE",
            "displayCode": "",
            "displayOrder": 45
        },{
            "id": 47,
            "value": "nationalID",
            "resultKey": "NATIONAL_ID",
            "displayCode": "",
            "displayOrder": 46
        },{
            "id": 48,
            "value": "category",
            "resultKey": "CATEGORY",
            "displayCode": "",
            "displayOrder": 47
        },{
            "id": 49,
            "value": "itemValue",
            "resultKey": "NQF_LEVEL",
            "displayCode": "",
            "displayOrder": 48
        },{
            "id": 50,
            "value": "saqaId",
            "resultKey": "SAQA_ID",
            "displayCode": "",
            "displayOrder": 49
        },{
            "id": 51,
            "value": "minProgramCredits",
            "resultKey": "NUMBER_OF_CREDITS",
            "displayCode": "",
            "displayOrder": 50
        },{
            "id": 52,
            "value": "programPeriodEnd",
            "resultKey": "PERIOD_END_DATE",
            "displayCode": "",
            "displayOrder": 51
        },{
            "id": 53,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_DISPLAY_NAME_ADM",
            "displayCode": "",
            "displayOrder": 52
        },{
            "id": 54,
            "value": "phoneCountryCode",
            "resultKey": "AL_PHONE_COUNTRY_CODE_ADM",
            "displayCode": "",
            "displayOrder": 53
        },{
            "id": 55,
            "value": "phoneNo",
            "resultKey": "AL_PHONE_NO_ADM",
            "displayCode": "",
            "displayOrder": 54
        },{
            "id": 56,
            "value": "cellCountryCode",
            "resultKey": "ACADEMY_LOC_CELL_COUNTRY_CODE_ADM",
            "displayCode": "",
            "displayOrder": 55
        },{
            "id": 57,
            "value": "cellNo",
            "resultKey": "ACADEMY_LOC_CELL_NO_ADM",
            "displayCode": "",
            "displayOrder": 56
        },{
            "id": 58,
            "value": "addressText",
            "resultKey": "ADDRESSTEXT_ADM",
            "displayCode": "",
            "displayOrder": 57
        },{
            "id": 59,
            "value": "cityName",
            "resultKey": "ADDRESSTEXTCITYNAME_ADM",
            "displayCode": "",
            "displayOrder": 58
        },{
            "id": 60,
            "value": "pincode",
            "resultKey": "ADDRESSTEXTPINCODE_ADM",
            "displayCode": "",
            "displayOrder": 59
        },{
            "id": 61,
            "value": "countryName",
            "resultKey": "ADDRESSTEXTCOUNTRYNAME_ADM",
            "displayCode": "",
            "displayOrder": 60
        },{
            "id": 62,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOC_PRIMARY_EMAIL_ID_ADM",
            "displayCode": "",
            "displayOrder": 61
        },{
            "id": 63,
            "value": "mobileCountryCode",
            "resultKey": "MOBILECODE_STU",
            "displayCode": "",
            "displayOrder": 62
        },{
            "id": 64,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NUMBER_STU",
            "displayCode": "",
            "displayOrder": 63
        },{
            "id": 65,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 64
        },{
            "id": 66,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 65
        },{
            "id": 67,
            "value": "printName",
            "resultKey": "STUDENT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 66
        },{
            "id": 68,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 67
        },{
            "id": 69,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 68
        },{
            "id": 70,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 69
        },{
            "id": 71,
            "value": "certificateName",
            "resultKey": "LETTER_NAME",
            "displayCode": "",
            "displayOrder": 70
        },{
            "id": 72,
            "value": "addressText",
            "resultKey": "ACADEMY_LOCATION_ADDR",
            "displayCode": "",
            "displayOrder": 71
        }
    ]
 }'
where dataProviderId = @dtproviderId; 
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240315132134__Update_UpdatePrintCertificateEvent () $$
DROP PROCEDURE IF EXISTS V20240315132134__Update_UpdatePrintCertificateEvent $$
DELIMITER ;