DELIMITER $$
DROP PROCEDURE IF EXISTS V20240319104647__Create_certificate_roles $$
CREATE PROCEDURE V20240319104647__Create_certificate_roles()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='certificate_roles')) THEN 
CREATE TABLE `certificate_roles` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `certificateId` BIGINT NOT NULL,
  `roleId` BIGINT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL ,
  PRIMARY KEY (`id`),
  INDEX `roleId_idx` (`roleId` ASC) VISIBLE,
  INDEX `certificate_foreign_key_idx` (`certificateId` ASC) VISIBLE,
  CONSTRAINT `role_foreign_key`
    FOREIGN KEY (`roleId`)
    REFERENCES `roles` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `certificate_foreign_key`
    FOREIGN KEY (`certificateId`)
    REFERENCES `certificates` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_certificate_roles_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);  
END IF; 

END $$
CALL V20240319104647__Create_certificate_roles () $$ 
DROP PROCEDURE IF EXISTS V20240319104647__Create_certificate_roles $$ 
DELIMITER ;