DROP procedure IF EXISTS `delete_applicant`;
DELIMITER $$
CREATE PROCEDURE `delete_applicant`(applicationIds TEXT)
BEGIN

SET SQL_SAFE_UPDATES=0;
SET FOREIGN_KEY_CHECKS=0;
SET SESSION group_concat_max_len = 1000000;

select group_concat(distinct application.applicantPersonId)  into @ApplicantPersonIds
from application where FIND_IN_SET(application.id,applicationIds);

select group_concat(distinct application_program.id)  into @ApplicantProgramIds
from application_program where FIND_IN_SET(application_program.applicationId,applicationIds);

select group_concat(distinct application_prog_stage.id)  into @ApplicantProgramStageIds
from application_prog_stage where FIND_IN_SET(application_prog_stage.applicationProgramId, @ApplicantProgramIds);

-- Start Delete Applicant Selection stage Related Data
DELETE from application_prog_stage_status where  
FIND_IN_SET(application_prog_stage_status.applicationProgramStageId, @ApplicantProgramStageIds);
 
DELETE from application_prog_stage_marks where 
FIND_IN_SET(application_prog_stage_marks.applicationProgramStageId, @ApplicantProgramStageIds);

-- Conditional admission documents
DELETE acdl,ed,d from application_condition_doc_log acdl inner join application_condition_log acl
on acdl.applicationConditionLogId=acl.id inner join documents d on d.id=acdl.documentId
inner join extended_documents ed on ed.documentId=d.id
where FIND_IN_SET(acl.applicationId,applicationIds);

DELETE acl,ac FROM application_condition_log acl inner join application_condition ac
on acl.applicationConditionId=ac.id
where FIND_IN_SET(acl.applicationId,applicationIds);

-- End Delete Applicant Selection stage Related Data

-- Start Applicant User Login History
DELETE  e2 from external_user_association e1 inner join
user_login_history e2 on e1.externalUserId=e2.externalUsersId where
FIND_IN_SET(e1.applicationId ,applicationIds);
-- End Applicant User Login History

-- Start Delete Applicant Fees related Data

DELETE afpd, afd FROM application_fee_plan_details afpd inner join application_fee_details afd
on afpd.applicationFeeDetailId=afd.id where
 FIND_IN_SET(afd.applicationId,applicationIds);

-- RECEIPT Adjustment Details  
DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
on fdm.id=fad.adjustmentMasterId
inner join receipt_header rh on rh.id=fdm.receiptHeaderId
where FIND_IN_SET(rh.applicantId,applicationIds);

DELETE FROM receipt_payment_instrument where receiptHeaderId in (
select id FROM receipt_header where
FIND_IN_SET(receipt_header.applicantId,applicationIds));

--  RECEIPT Voucher
DELETE vd,rv,v from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join receipt_voucher rv on v.id=rv.voucherId
inner join receipt_header rh on rh.id=rv.receiptHeaderId
where FIND_IN_SET(rh.applicantId,applicationIds);

-- RECEIPT 
DELETE FROM receipt_header where FIND_IN_SET(receipt_header.applicantId,applicationIds);

-- Offline Payment Header
DELETE FROM offline_payment_instrument where offlinePaymentHeaderId in (
select id FROM offline_payment_header where
FIND_IN_SET(offline_payment_header.applicationId,applicationIds));

DELETE FROM offline_payment_document where offlinePaymentHeaderId in (
select id FROM offline_payment_header where
FIND_IN_SET(offline_payment_header.applicationId,applicationIds));

DELETE FROM offline_payment_header where FIND_IN_SET(offline_payment_header.applicationId,applicationIds);

-- End Offline Payment Header

-- PAYMENT Voucher 
DELETE vd,pv,v,ph from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join payment_voucher pv on v.id=pv.voucherId
inner join payment_header ph on ph.id=pv.paymentHeaderId
where FIND_IN_SET(ph.applicantId,applicationIds);

-- BILL Voucher
DELETE vd,bv,v,bh from voucher_detail vd 
inner join voucher v on v.id=vd.voucherId
inner join bill_voucher bv on v.id=bv.voucherId
inner join bill_header bh on bh.id=bv.billId
where FIND_IN_SET(bh.applicantId,applicationIds);

-- BILL Adjustment Details  
DELETE  fad, fdm FROM fee_adjustment_details fad inner join fee_adjustment_master fdm
on fdm.id=fad.adjustmentMasterId
inner join bill_header bh on bh.id=fdm.billHeaderId
where FIND_IN_SET(bh.applicantId,applicationIds);

-- Applicant Discount 
DELETE FROM applicant_student_discount_master 
where FIND_IN_SET(applicant_student_discount_master.applicantId,applicationIds);

 -- Bill Discount details
DELETE bdd FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
inner join bill_discount_details bdd on bdd.billFeePlanRuleStageId=bfprs.id
where FIND_IN_SET(bh.applicantId,applicationIds);

-- Bill And Fee plan rule stage details
DELETE bfprs FROM bill_fee_plan_rule_stage bfprs inner join bill_header bh on bfprs.billId=bh.id
where FIND_IN_SET(bh.applicantId,applicationIds);

-- BILL 
DELETE FROM bill_header where FIND_IN_SET(bill_header.applicantId,applicationIds);

DELETE from application_prog_stage where
FIND_IN_SET(application_prog_stage.id, @ApplicantProgramStageIds);

-- END Delete Applicant Fees related Data

-- Start Delete Applicant other details Data

-- Applicant Documents
DELETE ard,ed,d from application_required_documents ard 
inner join documents d on d.id=ard.documentId
inner join extended_documents ed on ed.documentId=d.id
where FIND_IN_SET(ard.applicationId,applicationIds);

DELETE FROM application_required_documents where
FIND_IN_SET(application_required_documents.applicationId,applicationIds);
--

DELETE FROM applicant_address where 
FIND_IN_SET(applicant_address.applicantPersonId, @ApplicantPersonIds);

DELETE FROM fee_payer_detail where  
FIND_IN_SET(fee_payer_detail.applicantPersonId, @ApplicantPersonIds);

DELETE  e1,e2 from external_user_association e1 inner join 
external_users e2 on e1.externalUserId=e2.id where
FIND_IN_SET(e1.applicationId ,applicationIds);

DELETE FROM application_admission_detail where 
FIND_IN_SET(application_admission_detail.applicationProgramId, @ApplicantProgramIds);

DELETE from application_timeline where 
FIND_IN_SET(application_timeline.applicationId ,applicationIds);

DELETE from application_program where FIND_IN_SET(application_program.applicationId ,applicationIds);

DELETE apr,ap  FROM applicant_person_relationships  apr inner join applicant_person ap on 
apr.relatedApplicantPersonId=ap.id
where FIND_IN_SET(apr.applicantPersonId, @ApplicantPersonIds);

DELETE  a , af from application a inner join application_form af 
on a.applicationFormId =af.id where FIND_IN_SET(a.id ,applicationIds);

DELETE FROM economic_information where FIND_IN_SET(economic_information.applicant_person_id ,@ApplicantPersonIds);

DELETE FROM applicant_person where FIND_IN_SET(applicant_person.id ,@ApplicantPersonIds);

DELETE FROM application where FIND_IN_SET(application.id ,applicationIds);

-- END Delete Applicant other details Data
SET SQL_SAFE_UPDATES=1;
SET FOREIGN_KEY_CHECKS=1;
	
END$$

DELIMITER ;

