DELIMITER $$
DROP PROCEDURE IF EXISTS V20240514114648__Create_LearningAllowance $$
CREATE PROCEDURE V20240514114648__Create_LearningAllowance()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_allowance') THEN 
CREATE TABLE `learning_allowance`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint(20) NOT NULL,
`description` varchar(300) NULL,
`validForm` date DEFAULT NULL,
`accountType` bigint(20) NULL,
`grantedby` bigint(20) NULL,
`dateModified` date DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_learningallowance_FK_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_learningallowance_FK_accountType` FOREIGN KEY (`accountType`) REFERENCES `academy_location` (`id`),
CONSTRAINT `FK_learningallowance_FK_grantedby` FOREIGN KEY (`grantedby`) REFERENCES `users` (`id`),
CONSTRAINT `FK_learningallowance_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF;


END $$
CALL V20240514114648__Create_LearningAllowance () $$ 
DROP PROCEDURE IF EXISTS V20240514114648__Create_LearningAllowance $$ 
DELIMITER ;