DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseFacultyMappingbb $$
CREATE PROCEDURE fatchCourseFacultyMappingbb()
BEGIN
    SELECT 
        bum.blackboardUserId AS 'blackboardUserId',
        bcm.blackboardCourseId AS 'blackboardCourseId',
        cv.id AS 'courseVariantsId',
        pbcf.facultyId AS 'facultyId'
    FROM prog_batch_course_faculty pbcf
    JOIN program_batch_course_param pbcp
        ON pbcp.id = pbcf.progBatchCourseParamId
    JOIN course_variants cv
        ON cv.id = pbcp.courseVarientId
    JOIN courses c
        ON c.id = cv.courseId
    JOIN blackboard_course_mapping bcm
        ON bcm.academiaCourseVariantId = cv.id
    JOIN blackboard_user_mapping bum
        ON bum.academiaUserId = pbcf.facultyId
    LEFT JOIN blackboard_user_course_membership_mapping bumm
        ON bumm.academiaCourseVariantId = cv.id
        AND bumm.academiaUserId = pbcf.facultyId
    WHERE bumm.id IS NULL;
END $$ 
DELIMITER ;