DROP procedure IF EXISTS `sp_search_table_master`;

DELIMITER $$
CREATE PROCEDURE `sp_search_table_master`(in databaseName varchar(100), in timeIntervel bigint)
BEGIN
START TRANSACTION;
BLOCK1: begin
SET FOREIGN_KEY_CHECKS=0;
SET SQL_SAFE_UPDATES = 0;
TRUNCATE TABLE  `basic_search_config`;
TRUNCATE TABLE  `basic_search_config_param`;
TRUNCATE TABLE  `default_search_criterias`;
TRUNCATE TABLE  `saved_search`;
TRUNCATE TABLE  `saved_search_criteria`;
TRUNCATE TABLE  `saved_search_sort_criteria`;
TRUNCATE TABLE  `search_aggregation_column`;
TRUNCATE TABLE  `search_config`;
TRUNCATE TABLE  `search_config_table`;
TRUNCATE TABLE  `search_implicit_criteria`;
TRUNCATE TABLE  `search_result_enhancer`;
TRUNCATE TABLE  `search_result_view`;
TRUNCATE TABLE  `search_result_view_column`;
TRUNCATE TABLE  `search_result_view_sort`;
TRUNCATE TABLE  `search_sql_group`;
TRUNCATE TABLE  `search_sql_groupby`;
TRUNCATE TABLE  `search_result_formatter_params`;
-- TRUNCATE TABLE  `search_table`
-- TRUNCATE TABLE  `search_table_column`
-- TRUNCATE TABLE  `search_table_relation`
-- set @dropSearchTableId = (select GROUP_CONCAT(searchTableId) from search_table_column where criteriaPrivilegeLevel = "0");
-- delete from search_table_column where find_in_set(searchTableId, @dropSearchTableId);
delete from search_table where id in(select searchTableId from search_table_column where criteriaPrivilegeLevel = "1");
delete from search_table_column where criteriaPrivilegeLevel = "1";
SET SQL_SAFE_UPDATES = 1;
SET FOREIGN_KEY_CHECKS=1;
END BLOCK1;
BLOCK2: begin
if (timeIntervel is null) then set timeIntervel:= 5; end if;
insert into `search_table` (`dbTableName`,`i18nDisplayCode`) 
(select 
	table_name, concat('cb.',table_name)
from information_schema.tables
left join search_table on information_schema.tables.table_name = search_table.dbTableName
left join search_skip_table on  information_schema.tables.table_name = search_skip_table.skipColumnName
where 
-- DATE_SUB(NOW(), INTERVAL timeIntervel second) < `create_time` and 
table_schema not in('information_schema', 'mysql', 'performance_schema','sys')
     and table_type ='BASE TABLE' and table_schema = databaseName and search_table.id is null and search_skip_table.skipColumnName is null);
select 
	search_table.id, search_table.dbTableName
from information_schema.tables
left join search_table on information_schema.tables.table_name = search_table.dbTableName
left join search_skip_table on  information_schema.tables.table_name = search_skip_table.skipColumnName
where 
-- DATE_SUB(NOW(), INTERVAL timeIntervel second) < `create_time` and 
table_schema not in('information_schema', 'mysql', 'performance_schema','sys')
     and table_type ='BASE TABLE' and table_schema = databaseName and search_skip_table.skipColumnName is null;
END BLOCK2;
END$$
DELIMITER ;