DELIMITER $$
DROP PROCEDURE IF EXISTS V20240619181616__Insert_SendEmailMonthlyUsageDataEvent $$
CREATE PROCEDURE V20240619181616__Insert_SendEmailMonthlyUsageDataEvent()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='SCHOLARSHIP');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SEND_EMAIL_FOR_MONTHLY_USAGE_DATA');
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SEND_EMAIL_FOR_MONTHLY_USAGE_DATA', 'Send Email For Monthly Usage Data', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Send Email For Monthly Usage Data');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 -- Template data provider for the Event
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT', 'SQL');
 
 -- Create Recipient Type
 
 SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
 
 
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID FROM user_usage_email_internal T1",NULL);
 
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT 
    T1.`id` AS ID,
    T1.`itemCode` AS FIRST_NAME,
    T1.`itemValue` AS EMAIL_ID,
    T2.id AS emailNo
FROM
    user_usage_email_internal T1
        LEFT JOIN
    send_monthly_report_path T2 ON 1 = 1
        AND DATE(T2.lastUpdate) = DATE(NOW())
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id",'{
     "id": 1,
     "searchResultViewColumns": [
        {
            "id": 1,
            "value": "itemCode",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
		 {
            "id": 2,
            "value": "itemValue",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 3,
            "value": "id",
            "resultKey": "emailNo",
            "displayCode": "",
            "displayOrder": 2
        }
    ]
 }');
 
 SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T3.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Send Email For Monthly Usage Data Email',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Send Email For Monthly Usage Data Email',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
END IF; 

END $$
CALL V20240619181616__Insert_SendEmailMonthlyUsageDataEvent() $$
DROP PROCEDURE IF EXISTS V20240619181616__Insert_SendEmailMonthlyUsageDataEvent $$
DELIMITER ;