DELIMITER $$
DROP PROCEDURE IF EXISTS V20240625170444__Create_AttestationCertifiStudentProfile $$
CREATE PROCEDURE V20240625170444__Create_AttestationCertifiStudentProfile()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attestation_certificate_for_student_profile')) THEN 
CREATE TABLE `attestation_certificate_for_student_profile` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NOT NULL,
  `printAsWordFile` BIT NOT NULL,
  `path` VARCHAR(255) NOT NULL,
  `fileName` VARCHAR(255) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `attestation_certificateadmission_fk`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`),
  CONSTRAINT `attestation_certificateuser_fk`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));

END IF; 

END $$
CALL V20240625170444__Create_AttestationCertifiStudentProfile () $$ 
DROP PROCEDURE IF EXISTS V20240625170444__Create_AttestationCertifiStudentProfile $$ 
DELIMITER ;