DELIMITER $$
DROP PROCEDURE IF EXISTS V20240720122908__Insert_quotation_template_international $$
CREATE PROCEDURE V20240720122908__Insert_quotation_template_international()
BEGIN

IF NOT EXISTS ((select * from report_type where typeName = 'Quotation')) THEN 
INSERT INTO `report_type` (`typeName`) VALUES ('Quotation');
set @OutstandingVoucherId = (select max(id) from report_type where typeName ='Quotation');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'QUOTATION_INTERNATIONAL_STUDENT')) THEN 
set @OutstandingVoucherId = (select max(id) from report_type where typeName ='Quotation');
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@OutstandingVoucherId, 'QUOTATION_INTERNATIONAL_STUDENT', 'Quotation International Student', 'QUOTATION_INTERNATIONAL_STUDENT.png', 'Quotation_For_International_Student.jasper', 'All', '1', null, null, '1', '1', 'QUOTATION_INTERNATIONAL_STUDENT.jasper', 'AcademiaLogo.png');
END IF; 

set @QuotationForInternationalTemplate = (select max(id) from report_template where templateCode ='QUOTATION_INTERNATIONAL_STUDENT');


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PROVISIONAL_QUOTATION_GIVEN_WITHOUT_PREJUDICE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PROVISIONAL_QUOTATION_GIVEN_WITHOUT_PREJUDICE', 'PROVISIONAL QUOTATION GIVEN WITHOUT PREJUDICE', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'IT_IS_HEREBY_CERTIFIED_THAT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'IT_IS_HEREBY_CERTIFIED_THAT', 'It is hereby certified that', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'ACADEMIC_YEAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'ACADEMIC_YEAR', 'Academic year', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'COURSE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'COURSE', 'Course', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PROGRAMME')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PROGRAMME', 'Programme', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'TOTAL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'TOTAL', 'Total', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'MINIMUM_AMOUNT_PAYABLE_ON_PRIOR_TO_REGISTRATION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'MINIMUM_AMOUNT_PAYABLE_ON_PRIOR_TO_REGISTRATION', 'Minimum amount payable on/prior to registration', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'GENERAL_COMMENTS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'GENERAL_COMMENTS', 'GENERAL COMMENTS', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'BURSARY_STUDENTS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'BURSARY_STUDENTS', 'BURSARY STUDENTS', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'METHODS_OF_PAYMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'METHODS_OF_PAYMENT', 'METHODS OF PAYMENT', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PLEASE_NOTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PLEASE_NOTE', 'PLEASE NOTE', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'SADC_CITIZENS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'SADC_CITIZENS', 'SADC-citizens', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'ANGOLA')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'ANGOLA', 'Angola, Botswana, Comoros, DRC, Lesotho, Madagascar, Malawi, Mauritius, Mozambique, Namibia, Seychelles, Swaziland,', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'TANZANIA')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'TANZANIA', 'Tanzania, Zambia, Zimbabwe, incl. Rwanda', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'FOR_ANY_FINANCE_ENQUIRIES')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'FOR_ANY_FINANCE_ENQUIRIES', 'For any finance enquiries, please contact the SU International Finance Officer at', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'SUIFINANCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'SUIFINANCE', 'suifinance@sun.ac.za', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PLEASE_QUOTE_YOUR_STUDENT_NUMBER_IN_ALL_CORRESPONDENCE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PLEASE_QUOTE_YOUR_STUDENT_NUMBER_IN_ALL_CORRESPONDENCE', 'Please quote your student number in all correspondence.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_ONE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_ONE', 'was/has been/is to be registered as a student for the abovementioned course at the University for the above mentioned', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWO', 'academic year and that the fees set out below will be payable in respect of his/her studies, (subject to course selection):', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THREE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THREE', 'All outstanding amounts on student accounts for previous year(s) must be paid before a student will be allowed to register', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FOUR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FOUR', 'for a subsequent year. The total amount and the first instalment payable at registration quoted above do not include', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FIVE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FIVE', 'possible arrears', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_SIX')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_SIX', 'Fees and payment requirements differ for International students. A distinction is made between international students from the SADC region,', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_SEVEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_SEVEN', 'international students from Africa (Beyond SADC), and international students from the Rest of the world (Outside Africa).', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_EIGHT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_EIGHT', 'You will not be allowed to register if the minimum compulsory initial fee has not been received prior or upon registration.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_NINE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_NINE', 'If any other payment option is being used, a minimum of 14 working days as a turnaround for the payment to reflect in Stellenbosch University''s', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TEN', 'bank account will be permitted. You will not be able to activate your student card for academic services should the funds fail to reflect in your', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_ELEVEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_ELEVEN', 'student account following the turnaround time and a  late payment fee will be charged.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTEEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTEEN', 'The balance of the outstanding fees is payable in full by no later than 31st May for 1st semester enrolments and 30th September for 2nd', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FOURTEEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FOURTEEN', 'semester enrolments.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_EIGHTEEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_EIGHTEEN', 'Your student account will be blocked, interest will be charged and no academic results will be available if the student account is not settled by this date.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_ONE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_ONE', 'Since your fees account is based on your academic load and services used, it is your responsibility to check your student account regularly during', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_TWO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_TWO', 'the year.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_THREE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_THREE', 'A written proof that a bursary has been awarded, which indicates specifically the amount of the bursary as well as expected date of payment', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_FOUR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_FOUR', 'must be submitted to the SU International Finance Office, preferably before registration or otherwise during registration.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_FIVE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_FIVE', 'Proof of bursaries can also be sent via e-mail to suifinance@sun.ac.za, with student number reflecting on it clearly.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_EIGHT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_EIGHT', 'A student who can submit written proof to the SU International Finance Office that a bursary has been granted to her/him for the programme', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_TWENTY_NINE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_TWENTY_NINE', 'she/he is registering for in a particular year may be exempted from the minimum compulsory initial fee, by the date of registration, if the', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY', 'bursary is sufficient to cover the minimum compulsory initial fee.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_ONE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_ONE', 'If the bursary is less than the minimum compulsory initial fee, the student is responsible for paying the difference him/herself at the date of registration.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_TWO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_TWO', 'Online Electronic card payments are the best option of payment, since the fees will immediately reflect in the student account. Please use the', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_THREE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_THREE', 'following link:', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_FOUR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_FOUR', 'https://web-apps.sun.ac.za/student-fees-pay', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_FIVE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_FIVE', 'Please note that the following formal provision applies: "The Council reserves the right to amend without notice all fees payable to the', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_SIX')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_SIX', 'University, as circumstances may dictate."', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_SEVEN')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_SEVEN', 'The University reserves the right to make amendments of the content of this information at any time.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_EIGHT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_EIGHT', 'The Council and Senate of the University accept no liability in regard to inaccuracies, if any that may occur in the content of this provisional quotation.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_THIRTY_NINE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_THIRTY_NINE', 'Every reasonable care has been taken, however, to ensure that the relevant information to hand is represented on this provisional certificate, accurately', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FOURTY')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FOURTY', 'and in full.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FOURTY_ONE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FOURTY_ONE', 'Above figures are given for budgeting purposes only and therefore not binding Stellenbosch University thereto.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FOURTY_TWO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FOURTY_TWO', 'The University reserves the right to make amendments of the content of this information at any time. The Council and Senate of the University accept', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId=@QuotationForInternationalTemplate and `keyValue` = 'PARA_FOURTY_THREE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@QuotationForInternationalTemplate, 'PARA_FOURTY_THREE', 'no liability concerning inaccuracies, if any that may occur in the content of this provisional quotation', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM report_template_translations WHERE reportTemplateId=@QuotationForInternationalTemplate and keyValue = 'PLEASE_REFER_TO_THE_FOLLOWING_PAGE_FOR_IMPORTANT_INFORMATION')) THEN 
INSERT INTO report_template_translations (reportTemplateId, keyValue, defaultValue, lastUpdatedBy, lastUpdate)
VALUES (@QuotationForInternationalTemplate, 'PLEASE_REFER_TO_THE_FOLLOWING_PAGE_FOR_IMPORTANT_INFORMATION', 'Please refer to the following page for important information', '1', NOW());
END IF;

END $$
CALL V20240720122908__Insert_quotation_template_international() $$
DROP PROCEDURE IF EXISTS V20240720122908__Insert_quotation_template_international $$
DELIMITER ;