DELIMITER $$
DROP PROCEDURE IF EXISTS getEvaluationLevelThreeAvg $$
CREATE PROCEDURE getEvaluationLevelThreeAvg(
    IN evaluationSequenceId INT,
    IN courseVariantId INT
)
BEGIN
  SELECT
    CASE
        WHEN evalSeq.marksOrGrade = 'MARK' THEN
            (SELECT
                ROUND(AVG(seqRank.effectiveMarks)) AS avgMarksGrade
             FROM
                evaluation_sequence_rank AS seqRank
             WHERE
                seqRank.evaluationSequenceId = evalSeq.id
                AND seqRank.courseVariantId = courseVariantId)
        WHEN evalSeq.marksOrGrade = 'GRADE' THEN
            (SELECT
                g.gradeName as avgMarksGrade
             FROM
                grade AS g
             JOIN
                (SELECT
                    ROUND(AVG(seqRank.gradePoint)) AS average_gradePoint,
                    evalSeq.gradeType
                 FROM
                    evaluation_sequence_rank AS seqRank
                 JOIN
                    evaluation_sequence AS evalSeq ON evalSeq.id = seqRank.evaluationSequenceId
                 WHERE
                    seqRank.evaluationSequenceId = evalSeq.id
                    AND seqRank.courseVariantId = courseVariantId
                 GROUP BY
                    evalSeq.gradeType) AS avgGrades
             ON
                g.gradeType = avgGrades.gradeType
                AND g.gradePoint = avgGrades.average_gradePoint)
        ELSE
            NULL
    END AS result
FROM
    evaluation_sequence AS evalSeq
WHERE
    evalSeq.id = evaluationSequenceId;
END$$

DELIMITER ;