DELIMITER $$
DROP PROCEDURE IF EXISTS V20240808162612__Alter_isInactiveStd $$
CREATE PROCEDURE V20240808162612__Alter_isInactiveStd()
BEGIN

IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'program_withdraw_req_details' and column_name = 'isInactiveStudent')) THEN 
ALTER TABLE `program_withdraw_req_details` 
ADD COLUMN `isInactiveStudent` BIT(1)  Default false NOT NuLL;
END IF; 

IF NOT EXISTS ((select column_name from INFORMATION_SCHEMA.columns where table_schema=DATABASE() and table_name = 'program_withdraw_req_details' and column_name = 'periodId')) THEN 
ALTER TABLE `program_withdraw_req_details` 
ADD COLUMN `periodId` BIGINT NULL DEFAULT NULL,
ADD INDEX `program_withdraw_req_period_fk_idx` (`periodId` ASC) VISIBLE;
ALTER TABLE `program_withdraw_req_details` 
ADD CONSTRAINT `program_withdraw_req_period_fk`
  FOREIGN KEY (`periodId`)
  REFERENCES `prog_batch_period_config` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 

END $$
CALL V20240808162612__Alter_isInactiveStd() $$
DROP PROCEDURE IF EXISTS V20240808162612__Alter_isInactiveStd $$
DELIMITER ;