DELIMITER $$
DROP PROCEDURE IF EXISTS V20240808174731__Create_passout_rule $$
CREATE PROCEDURE V20240808174731__Create_passout_rule()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='passout_rule')) THEN 
CREATE TABLE `passout_rule`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`batchId` BIGINT(20) NOT NULL,
	`passoutRuleType` VARCHAR(50) NOT NULL,
	`progressionStatusId` BIGINT(20) NULL DEFAULT NULL,
	`passoutMinimumCredit` FLOAT NULL DEFAULT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `passout_rule_idx1` (`batchId` ASC),
	INDEX `passout_rule_idx2` (`progressionStatusId` ASC),
	INDEX `passout_rule_idx3` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_passout_rule_1` FOREIGN KEY (`batchId`) REFERENCES `batches`(`id`),
	CONSTRAINT `fk_passout_rule_2` FOREIGN KEY (`progressionStatusId`) REFERENCES `progression_status`(`id`),
	CONSTRAINT `fk_passout_rule_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20240808174731__Create_passout_rule () $$ 
DROP PROCEDURE IF EXISTS V20240808174731__Create_passout_rule $$ 
DELIMITER ;