DELIMITER $$
DROP PROCEDURE IF EXISTS V20240909161714__Create_em_Mormandie_Marksheet_BachelorRpt $$
CREATE PROCEDURE V20240909161714__Create_em_Mormandie_Marksheet_BachelorRpt()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );

IF NOT EXISTS ((select * from report_template where templateCode = 'EM_NORMANDIE_MARKSHEET_BACHELOR')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'EM_NORMANDIE_MARKSHEET_BACHELOR', 'EM Normandie Marksheet - Bachelor', 'EM_NORMANDIE_MARKSHEET_BACHELOR.png', 'CommonReport_EM_NORMANDIE_MARKSHEET_BACHELOR.jasper', 'EVALUATION_PLAN', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'EM_NORMANDIE_MARKSHEET_BACHELOR.jasper', 'AcademiaLogo.png');
END IF; 

set @tempId = (select max(id) from report_template where templateCode='EM_NORMANDIE_MARKSHEET_BACHELOR' and templateName='EM Normandie Marksheet - Bachelor');


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MARKSHEET_SEMESTER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MARKSHEET_SEMESTER', 'Marksheet for the Semester', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DATE_BIRTH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_DATE_BIRTH', 'Date of Birth', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_STUDENT_ID') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_COURSE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_COURSE', 'Course', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MAX_MARK') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MAX_MARK', 'Maximum Mark', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MARK_OBTAINED') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MARK_OBTAINED', 'Mark Obtained', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MARK20') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MARK20', 'Mark / 20', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_GRADE', 'Grade', '1', now());
END IF;
 

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_POTENTIALCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_POTENTIALCH', 'Potential CH', '1', now());
END IF; 
 
 
IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_VALIDATEDCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_VALIDATEDCH', 'Validated CH', '1', now());
END IF; 
 

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CREDIT_POINTS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_CREDIT_POINTS', 'Credit Points', '1', now());
END IF; 


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_AVG_PERIOD') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_AVG_PERIOD', 'Average over the period', '1', now());
END IF; 

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_GPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_GPA', 'GPA', '1', now());
END IF; 

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TOTAL_OFFE_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_TOTAL_OFFE_CREDITS', 'Total offered credits', '1', now());
END IF; 

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TOTAL_VALI_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_TOTAL_VALI_CREDITS', 'Total validated credits', '1', now());
END IF; 

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TOTAL_NON_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_TOTAL_NON_CREDITS', 'Total non-validated credits', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CUMULATIVEGPA') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_CUMULATIVEGPA', 'Cumulative GPA', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CUMULATIVE_OFF_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_CUMULATIVE_OFF_CREDITS', 'Cumulative offered credits', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CUMULATIVE_VALIDATE_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_CUMULATIVE_VALIDATE_CREDITS', 'Cumulative validated credits', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_CUMULATIVE_NONVALIDATE_CREDITS') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_CUMULATIVE_NONVALIDATE_CREDITS', 'Cumulative non-validated credits', '1', now());
END IF;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_MANAGEMENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_MANAGEMENT', 'Management', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_REGISTRAR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempId, 'TRANS_REGISTRAR', 'Registrar', '1', now());
END IF;


END $$
CALL V20240909161714__Create_em_Mormandie_Marksheet_BachelorRpt () $$ 
DROP PROCEDURE IF EXISTS V20240909161714__Create_em_Mormandie_Marksheet_BachelorRpt $$ 
DELIMITER ;