DELIMITER $$
DROP PROCEDURE IF EXISTS V20240912123805__Update_WhatsappConfiguration $$
CREATE PROCEDURE V20240912123805__Update_WhatsappConfiguration()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='whatsapp_configuration' AND column_name='sampleTemplate')) THEN 
ALTER TABLE whatsapp_configuration 
ADD COLUMN sampleTemplate VARCHAR(1000) NULL DEFAULT NULL AFTER value;
END IF;

IF EXISTS(SELECT * FROM standard_master where tableName="whatsapp_configuration") THEN
SET @standardMasterId=(SELECT id FROM standard_master where tableName="whatsapp_configuration");  
update standard_master
set moduleName="OTHER"
where id = @standardMasterId;
END IF;

IF EXISTS (select * from whatsapp_configuration where templateName="offer_letter") THEN
update whatsapp_configuration
set templateName = "Offer Letter"
where templateName="offer_letter";
END IF;

IF EXISTS (select * from whatsapp_configuration where templateName="Invoice") THEN
update whatsapp_configuration
set sampleTemplate = "Dear {{1}}/{{2}},
We hope you're doing well. Please find your invoice for the upcoming academic term attached. Kindly review the details and proceed with the payment by the due date mentioned.
Invoice Number: {{3}}
Total Amount: {{4}}
Due Date: {{5}}
If you have any questions or need assistance, feel free to reach out to us.
Thank you,
{{6}}"
where templateName="Invoice";
END IF;

IF EXISTS (select * from whatsapp_configuration where templateName="Offer Letter") THEN
update whatsapp_configuration
set sampleTemplate = "Dear {{1}}/{{2}},
Congratulations! An Offer letter for the {{3}} has been shared with you. To accept the offer please log on to the applicant portal
Thank you
Kind regards,
{{4}}"
where templateName="Offer Letter";
END IF;

IF EXISTS (select * from whatsapp_configuration where templateName="Marksheet") THEN
update whatsapp_configuration
set sampleTemplate = "Dear {{1}}/{{2}},
We are pleased to inform you that the marksheet for your {{3}} {{4}} exam is published. It can be accessed in the below attachment.
You can now view and download your results from the official student portal.
If you encounter any issues accessing your results, please reach out to Administartor.
Best regards,
{{5}}"
where templateName="Marksheet";
END IF;

IF EXISTS(SELECT * FROM standard_master_items where fieldLabel="ACTIVE_STATUS") THEN
update standard_master_items
set whetherReadOnly = false
where fieldLabel = "ACTIVE_STATUS";
END IF;

IF EXISTS(SELECT * FROM standard_master_items where fieldLabel="TEMPLATE_ID") THEN
update standard_master_items
set whetherReadOnly = false
where fieldLabel = "TEMPLATE_ID";
END IF;
 
IF NOT EXISTS(SELECT * FROM standard_master_items where dbFieldName ="sampleTemplate") THEN
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
SET @standardMasterMaxId=(SELECT id FROM standard_master where tableName="whatsapp_configuration" );
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`,`maxLength`)
VALUES (@ItemsMaxId + 1, 'sampleTemplate', 'SAMPLE_TEMPLATE', @standardMasterMaxId, 'TextArea', '5', 0, 0, 1, 0, '1', NOW(),1000);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SAMPLE_TEMPLATE')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS','SAMPLE_TEMPLATE','Sample Template','Sample Template','Voorbeeld Sjabloon','Mẫu mẫu',now(),1);
END IF;


SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240912123805__Update_WhatsappConfiguration () $$
DROP PROCEDURE IF EXISTS V20240912123805__Update_WhatsappConfiguration $$
DELIMITER ;