DELIMITER $$
DROP PROCEDURE IF EXISTS V20240930180841__Create_TransferCreditResultStatusCSMTable $$
CREATE PROCEDURE V20240930180841__Create_TransferCreditResultStatusCSMTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='transfer_credit_result_status_csm')) THEN 
CREATE TABLE `transfer_credit_result_status_csm` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `itemCode` VARCHAR(100) NOT NULL,
  `itemValue` VARCHAR(500) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `itemCode_UNIQUE` (`itemCode` ASC),
  UNIQUE INDEX `itemValue_UNIQUE` (`itemValue` ASC),
  INDEX `fk_transfer_credit_result_status_csm_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_transfer_credit_result_status_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20240930180841__Create_TransferCreditResultStatusCSMTable () $$ 
DROP PROCEDURE IF EXISTS V20240930180841__Create_TransferCreditResultStatusCSMTable $$ 
DELIMITER ;