DELIMITER $$
DROP PROCEDURE IF EXISTS V20241030141328__Insert_AwardAndRejectTranslation $$
CREATE PROCEDURE V20241030141328__Insert_AwardAndRejectTranslation()
BEGIN

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='AWARD_ACTIVATION_REJECTED')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Award Rejected', `customerDefineValue`='Award Rejected', `afriLanguage`='Toekenning afgekeur',
`vietLanguage`='Giải thưởng bị từ chối',`lastUpdate`=now(),`lastUpdatedBy`=1 WHERE objectName='TRANSLATIONS' AND keyName='AWARD_ACTIVATION_REJECTED';
END IF;
SET SQL_SAFE_UPDATES=1;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='SCHOLARSHIP_ACTIVATED')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'SCHOLARSHIP_ACTIVATED', 'Awarded', 'Awarded', 'Toegeken', 'được trao giải',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' AND keyName='AWARD_ACTIVATION_REJECTED')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,lastUpdate,lastUpdatedBy) 
VALUES ('TRANSLATIONS', 'AWARD_ACTIVATION_REJECTED', 'Award Rejected', 'Award Rejected', 'Toekenning afgekeur', 'Giải thưởng bị từ chối',now(),1);
END IF;

END $$
CALL V20241030141328__Insert_AwardAndRejectTranslation() $$
DROP PROCEDURE IF EXISTS V20241030141328__Insert_AwardAndRejectTranslation $$
DELIMITER ;