DELIMITER $$
DROP PROCEDURE IF EXISTS V20241125164641__Create_CityChildGridCSM $$
CREATE PROCEDURE V20241125164641__Create_CityChildGridCSM()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='city_pincode'))) THEN 
CREATE TABLE `city_pincode` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  		`citypincodeId` BIGINT(20) NULL,
  		`itemCode` varchar(255) NOT NULL,
        `sequence` varchar(255) NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
		INDEX `fk_city_pincode_id_idx` (`citypincodeId` ASC),
		INDEX `fk_city_pincode_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
	  	CONSTRAINT `fk_city_pincode_id_idx`
		    FOREIGN KEY (`citypincodeId`)
		    REFERENCES `city` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_city_pincode_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ;
END IF; 
        IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'city_pincode')) THEN 

		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'city_pincode','CITY_PINCODE','Fees & Payments','COMMON_MASTER',1,0,1,SYSDATE());
		
		
		SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='city_pincode');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='city';
		SET SQL_SAFE_UPDATES = 1;
		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'itemCode', 'PIN Code', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'sequence', 'Sequence', @standardMasterMaxId+1, 'Number', '2', 0, 0, 0, 1, '1',SYSDATE());
		
		


END IF; 

END $$
CALL V20241125164641__Create_CityChildGridCSM () $$ 
DROP PROCEDURE IF EXISTS V20241125164641__Create_CityChildGridCSM $$ 
DELIMITER ;