DELIMITER $$

DROP PROCEDURE IF EXISTS V20241128165536__Update_CourseDataGridUpdateFlyway $$

CREATE PROCEDURE V20241128165536__Update_CourseDataGridUpdateFlyway()
BEGIN
    SET SQL_SAFE_UPDATES = 0;

    -- Update for portalId = 1
    IF EXISTS (
        SELECT * 
        FROM data_grid 
        WHERE gridName = 'Academia.view.examinationcenters.evalresultlisting.CourseWiseGrid' 
          AND portalId = 1
    ) THEN
        UPDATE `data_grid` 
        SET `jsonObject` = '[{"id":null,"columnName":"PROGRAM_ID","dataIndex":"programId","columnVisibility":"HIDE","sequence":1,"mandatory":false},
        {"id":null,"columnName":"BATCH_ID","dataIndex":"batchId","columnVisibility":"HIDE","sequence":2,"mandatory":false},
        {"id":null,"columnName":"EVALUATION_PLAN_ID","dataIndex":"evaluationPlanId","columnVisibility":"HIDE","sequence":3,"mandatory":false},
        {"id":null,"columnName":"PROGRAM_NAME","dataIndex":"programName","columnVisibility":"HIDE","sequence":4,"mandatory":false},
        {"id":null,"columnName":"BATCH_NAME","dataIndex":"batchName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
        {"id":null,"columnName":"COURSE_CODE","dataIndex":"courseCode","columnVisibility":"SHOW","sequence":6,"mandatory":false},
        {"id":null,"columnName":"COURSE_NAME","dataIndex":"courseName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
        {"id":null,"columnName":"COURSE_VARIANT","dataIndex":"courseVariant","columnVisibility":"SHOW","sequence":8,"mandatory":false},
        {"id":null,"columnName":"EVALUATION_PLAN_NUMBER","dataIndex":"evaluationPlanNumber","columnVisibility":"SHOW","sequence":9,"mandatory":false},
        {"id":null,"columnName":"ADMISSION_NO","dataIndex":"admissionCode","columnVisibility":"SHOW","sequence":10,"mandatory":false},
        {"id":null,"columnName":"STUDENT_ID","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":11,"mandatory":false},
        {"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":12,"mandatory":false},
        {"id":null,"columnName":"FIRST_NAME","dataIndex":"firstName","columnVisibility":"HIDE","sequence":13,"mandatory":false},
        {"id":null,"columnName":"MIDDLE_NAME","dataIndex":"middleName","columnVisibility":"HIDE","sequence":14,"mandatory":false},
        {"id":null,"columnName":"LAST_NAME","dataIndex":"lastName","columnVisibility":"SHOW","sequence":15,"mandatory":false},
        {"id":null,"columnName":"MAX_MARKS","dataIndex":"maxMarks","columnVisibility":"SHOW","sequence":16,"mandatory":false},
        {"id":null,"columnName":"MAX_GRADE","dataIndex":"maxGrade","columnVisibility":"SHOW","sequence":17,"mandatory":false},
        {"id":null,"columnName":"OBTAINED_MARKS","dataIndex":"obtainedMarks","columnVisibility":"SHOW","sequence":18,"mandatory":false},
        {"id":null,"columnName":"OFFERED_CREDIT","dataIndex":"offeredCredit","columnVisibility":"SHOW","sequence":19,"mandatory":false},
        {"id":null,"columnName":"OFFERED_ECTS_CREDIT","dataIndex":"offeredEcts","columnVisibility":"SHOW","sequence":20,"mandatory":false},
        {"id":null,"columnName":"EFFECTIVE_MARKS","dataIndex":"effectiveMarks","columnVisibility":"SHOW","sequence":21,"mandatory":false},
        {"id":null,"columnName":"ACHIEVED_ECTS_CREDIT","dataIndex":"achievedEctsCredit","columnVisibility":"SHOW","sequence":22,"mandatory":false},
        {"id":null,"columnName":"OBTAINED_CREDIT","dataIndex":"obtainedCredit","columnVisibility":"SHOW","sequence":23,"mandatory":false},
        {"id":null,"columnName":"GRADE_OBTAINED","dataIndex":"gradeObtained","columnVisibility":"SHOW","sequence":24,"mandatory":false},
        {"id":null,"columnName":"GRADE_POINT","dataIndex":"gradePoint","columnVisibility":"SHOW","sequence":25,"mandatory":false},
        {"id":null,"columnName":"SECTION_WISE_COURSE_RANK","dataIndex":"sectionWiseCourseRank","columnVisibility":"SHOW","sequence":26,"mandatory":false},
        {"id":null,"columnName":"COURSE_RANK","dataIndex":"courseRank","columnVisibility":"SHOW","sequence":27,"mandatory":false},
        {"id":null,"columnName":"STATUS","dataIndex":"status","columnVisibility":"SHOW","sequence":28,"mandatory":false},
        {"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionId","columnVisibility":"HIDE","sequence":29,"mandatory":false},
        {"id":null,"columnName":"COURSE_VARIANT_ID","dataIndex":"courseVariantId","columnVisibility":"HIDE","sequence":30,"mandatory":false},
        {"id":null,"columnName":"SECTION_NAME","dataIndex":"sectionName","columnVisibility":"HIDE","sequence":31,"mandatory":false},
        {"id":null,"columnName":"SECTION_ID","dataIndex":"sectionId","columnVisibility":"HIDE","sequence":32,"mandatory":false},
        {"id":null,"columnName":"ID","dataIndex":"id","columnVisibility":"HIDE","sequence":33,"mandatory":false},
        {"id":null,"columnName":"REVISED_GRADE_OBTAINED","dataIndex":"revisedGradeObtained","columnVisibility":"HIDE","sequence":34,"mandatory":false},
        {"id":null,"columnName":"USER_STATUS","dataIndex":"userStatus","columnVisibility":"HIDE","sequence":35,"mandatory":false}]'
        WHERE gridName = 'Academia.view.examinationcenters.evalresultlisting.CourseWiseGrid' AND portalId = 1;
    END IF;

    -- Update for portalId = 2
    IF EXISTS (
        SELECT * 
        FROM data_grid 
        WHERE gridName = 'Academia.view.examinationcenters.evalresultlisting.CourseWiseGrid' 
          AND portalId = 2
    ) THEN
        UPDATE `data_grid` 
        SET `jsonObject` = '[{"id":null,"columnName":"PROGRAM_ID","dataIndex":"programId","columnVisibility":"HIDE","sequence":1,"mandatory":false},
        {"id":null,"columnName":"BATCH_ID","dataIndex":"batchId","columnVisibility":"HIDE","sequence":2,"mandatory":false},
        {"id":null,"columnName":"EVALUATION_PLAN_ID","dataIndex":"evaluationPlanId","columnVisibility":"HIDE","sequence":3,"mandatory":false},
        {"id":null,"columnName":"PROGRAM_NAME","dataIndex":"programName","columnVisibility":"HIDE","sequence":4,"mandatory":false},
        {"id":null,"columnName":"BATCH_NAME","dataIndex":"batchName","columnVisibility":"HIDE","sequence":5,"mandatory":false},
        {"id":null,"columnName":"COURSE_CODE","dataIndex":"courseCode","columnVisibility":"SHOW","sequence":6,"mandatory":false},
        {"id":null,"columnName":"COURSE_NAME","dataIndex":"courseName","columnVisibility":"SHOW","sequence":7,"mandatory":false},
        {"id":null,"columnName":"COURSE_VARIANT","dataIndex":"courseVariant","columnVisibility":"SHOW","sequence":8,"mandatory":false},
        {"id":null,"columnName":"EVALUATION_PLAN_NUMBER","dataIndex":"evaluationPlanNumber","columnVisibility":"SHOW","sequence":9,"mandatory":false},
        {"id":null,"columnName":"ADMISSION_NO","dataIndex":"admissionCode","columnVisibility":"SHOW","sequence":10,"mandatory":false},
        {"id":null,"columnName":"STUDENT_ID","dataIndex":"studentCode","columnVisibility":"SHOW","sequence":11,"mandatory":false},
        {"id":null,"columnName":"STUDENT_NAME","dataIndex":"studentName","columnVisibility":"SHOW","sequence":12,"mandatory":false},
        {"id":null,"columnName":"FIRST_NAME","dataIndex":"firstName","columnVisibility":"HIDE","sequence":13,"mandatory":false},
        {"id":null,"columnName":"MIDDLE_NAME","dataIndex":"middleName","columnVisibility":"HIDE","sequence":14,"mandatory":false},
        {"id":null,"columnName":"LAST_NAME","dataIndex":"lastName","columnVisibility":"SHOW","sequence":15,"mandatory":false},
        {"id":null,"columnName":"MAX_MARKS","dataIndex":"maxMarks","columnVisibility":"SHOW","sequence":16,"mandatory":false},
        {"id":null,"columnName":"MAX_GRADE","dataIndex":"maxGrade","columnVisibility":"SHOW","sequence":17,"mandatory":false},
        {"id":null,"columnName":"OBTAINED_MARKS","dataIndex":"obtainedMarks","columnVisibility":"SHOW","sequence":18,"mandatory":false},
        {"id":null,"columnName":"OFFERED_CREDIT","dataIndex":"offeredCredit","columnVisibility":"SHOW","sequence":19,"mandatory":false},
        {"id":null,"columnName":"OFFERED_ECTS_CREDIT","dataIndex":"offeredEcts","columnVisibility":"SHOW","sequence":20,"mandatory":false},
        {"id":null,"columnName":"EFFECTIVE_MARKS","dataIndex":"effectiveMarks","columnVisibility":"SHOW","sequence":21,"mandatory":false},
        {"id":null,"columnName":"ACHIEVED_ECTS_CREDIT","dataIndex":"achievedEctsCredit","columnVisibility":"SHOW","sequence":22,"mandatory":false},
        {"id":null,"columnName":"OBTAINED_CREDIT","dataIndex":"obtainedCredit","columnVisibility":"SHOW","sequence":23,"mandatory":false},
        {"id":null,"columnName":"GRADE_OBTAINED","dataIndex":"gradeObtained","columnVisibility":"SHOW","sequence":24,"mandatory":false},
        {"id":null,"columnName":"GRADE_POINT","dataIndex":"gradePoint","columnVisibility":"SHOW","sequence":25,"mandatory":false},
        {"id":null,"columnName":"SECTION_WISE_COURSE_RANK","dataIndex":"sectionWiseCourseRank","columnVisibility":"SHOW","sequence":26,"mandatory":false},
        {"id":null,"columnName":"COURSE_RANK","dataIndex":"courseRank","columnVisibility":"SHOW","sequence":27,"mandatory":false},
        {"id":null,"columnName":"STATUS","dataIndex":"status","columnVisibility":"SHOW","sequence":28,"mandatory":false},
        {"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionId","columnVisibility":"HIDE","sequence":29,"mandatory":false},
        {"id":null,"columnName":"COURSE_VARIANT_ID","dataIndex":"courseVariantId","columnVisibility":"HIDE","sequence":30,"mandatory":false},
        {"id":null,"columnName":"SECTION_NAME","dataIndex":"sectionName","columnVisibility":"HIDE","sequence":31,"mandatory":false},
        {"id":null,"columnName":"SECTION_ID","dataIndex":"sectionId","columnVisibility":"HIDE","sequence":32,"mandatory":false},
        {"id":null,"columnName":"ID","dataIndex":"id","columnVisibility":"HIDE","sequence":33,"mandatory":false},
        {"id":null,"columnName":"REVISED_GRADE_OBTAINED","dataIndex":"revisedGradeObtained","columnVisibility":"HIDE","sequence":34,"mandatory":false},
        {"id":null,"columnName":"USER_STATUS","dataIndex":"userStatus","columnVisibility":"HIDE","sequence":35,"mandatory":false}]'
        WHERE gridName = 'Academia.view.examinationcenters.evalresultlisting.CourseWiseGrid' AND portalId = 2;
    END IF;

    SET SQL_SAFE_UPDATES = 1;
END $$

CALL V20241128165536__Update_CourseDataGridUpdateFlyway() $$

DROP PROCEDURE IF EXISTS V20241128165536__Update_CourseDataGridUpdateFlyway $$

DELIMITER ;
