DELIMITER $$
DROP PROCEDURE IF EXISTS V20241210175529__Alter_AddPinCodeNewOnApplicantPerson $$
CREATE PROCEDURE V20241210175529__Alter_AddPinCodeNewOnApplicantPerson()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'applicant_address' 
      AND COLUMN_NAME = 'cityPinCodeId'
) THEN
    ALTER TABLE applicant_address
    ADD COLUMN cityPinCodeId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'applicant_address' 
      AND CONSTRAINT_NAME = 'FK_applicant_city_pincode'
) THEN
    ALTER TABLE applicant_address
    ADD CONSTRAINT FK_applicant_city_pincode FOREIGN KEY (cityPinCodeId) REFERENCES city_pincode(id);
END IF;

END $$
CALL V20241210175529__Alter_AddPinCodeNewOnApplicantPerson() $$
DROP PROCEDURE IF EXISTS V20241210175529__Alter_AddPinCodeNewOnApplicantPerson $$
DELIMITER ;