DELIMITER $$
DROP PROCEDURE IF EXISTS V20241223155901__Update_EmployeeLeaveRejectDLRecipient $$
CREATE PROCEDURE V20241223155901__Update_EmployeeLeaveRejectDLRecipient()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select MAX(id) from dtprovider where dataProviderName="LEAVE_REJECT_DL") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="LEAVE_REJECT_DL");

update sql_dtprovider set sqlQuery="SELECT 
    id AS USER_ID
FROM
    hr_emp_leave_request_detail
WHERE
    id IN (namedParams) and status ='REJECTED'"
   where dataProviderId=@dtProviderId;  

END IF; 

IF EXISTS (select MAX(id) from dtprovider where dataProviderName="LEAVE_REJECT_RECIPIENT") THEN 

SET @dtProviderId=(select MAX(id) from dtprovider where dataProviderName="LEAVE_REJECT_RECIPIENT");

update sql_dtprovider set sqlQuery="SELECT 
    T2.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T2.comment AS REASON,
    approver.printName AS REJECTER_PRINT_NAME,
    approver.firstName AS REJECTER_FIRST_NAME,
    approver.middleName AS REJECTER_MIDDLE_NAME,
    approver.lastName AS REJECTER_LAST_NAME,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID, 
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    ml.code as LANGUAGE_KEY
FROM
    hr_emp_leave_request AS T1
        INNER JOIN
    hr_emp_leave_request_detail AS T2 ON T2.empLeaveRequestId = T1.id
        INNER JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        INNER JOIN
    persons AS requester ON requester.id = T3.personId
        INNER JOIN
    users AS reqUser ON reqUser.id = T3.userId
        INNER JOIN
    staffs AS T4 ON T4.userId = T2.approverId
        INNER JOIN
    persons AS approver ON approver.id = T4.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    multi_language ml on ml.id=requester.correspondence_language
WHERE
    T2.id IN (namedParams) AND T1.status = 'REJECTED' AND T2.status = 'REJECTED'"
   where dataProviderId=@dtProviderId;  

END IF; 

SET SQL_SAFE_UPDATES=1;

END $$
CALL V20241223155901__Update_EmployeeLeaveRejectDLRecipient () $$
DROP PROCEDURE IF EXISTS V20241223155901__Update_EmployeeLeaveRejectDLRecipient $$
DELIMITER ;