DELIMITER $$
DROP PROCEDURE IF EXISTS V20241231154026__Create_student_journey_attributes $$
CREATE PROCEDURE V20241231154026__Create_student_journey_attributes()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_journey_attributes')) THEN 
CREATE TABLE `student_journey_attributes` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `studentJourneyId` BIGINT NOT NULL,
  `attributeCode` VARCHAR(50) NOT NULL,
  `attributeValue` VARCHAR(255) NOT NULL,
  `lastUpdated` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `studentJourneyId_idx` (`studentJourneyId` ASC),
  CONSTRAINT `studentJourneyId`
    FOREIGN KEY (`studentJourneyId`)
    REFERENCES `student_journey` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20241231154026__Create_student_journey_attributes () $$ 
DROP PROCEDURE IF EXISTS V20241231154026__Create_student_journey_attributes $$ 
DELIMITER ;